/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.dml.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.algorithm.DuplicateInsertDataRecordException;
import org.apache.shardingsphere.sharding.exception.syntax.InsertSelectTableViolationException;
import org.apache.shardingsphere.sharding.exception.syntax.MissingGenerateKeyColumnWithInsertSelectException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedShardingOperationException;
import org.apache.shardingsphere.sharding.exception.syntax.UnsupportedUpdatingShardingValueException;
import org.apache.shardingsphere.sharding.route.engine.condition.ShardingConditions;
import org.apache.shardingsphere.sharding.route.engine.type.standard.ShardingStandardRoutingEngine;
import org.apache.shardingsphere.sharding.route.engine.validator.dml.ShardingDMLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.column.OnDuplicateKeyColumnsSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.InsertStatement;

public final class ShardingInsertStatementValidator
extends ShardingDMLStatementValidator {
    private final ShardingConditions shardingConditions;

    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props) {
        if (null == ((InsertStatementContext)sqlStatementContext).getInsertSelectContext()) {
            this.validateMultipleTable(shardingRule, sqlStatementContext);
        }
        InsertStatement insertStatement = (InsertStatement)sqlStatementContext.getSqlStatement();
        String tableName = insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        Optional insertSelectSegment = insertStatement.getInsertSelect();
        if (insertSelectSegment.isPresent() && this.isContainsKeyGenerateStrategy(shardingRule, tableName) && !this.isContainsKeyGenerateColumn(shardingRule, insertStatement.getColumns(), tableName)) {
            throw new MissingGenerateKeyColumnWithInsertSelectException();
        }
        TablesContext tablesContext = ((InsertStatementContext)sqlStatementContext).getTablesContext();
        if (insertSelectSegment.isPresent() && shardingRule.containsShardingTable(tablesContext.getTableNames()) && !this.isAllSameTables(tablesContext.getTableNames()) && !shardingRule.isAllBindingTables(tablesContext.getTableNames())) {
            throw new InsertSelectTableViolationException();
        }
    }

    private boolean isContainsKeyGenerateStrategy(ShardingRule shardingRule, String tableName) {
        return shardingRule.findGenerateKeyColumnName(tableName).isPresent();
    }

    private boolean isContainsKeyGenerateColumn(ShardingRule shardingRule, Collection<ColumnSegment> columns, String tableName) {
        return columns.isEmpty() || columns.stream().anyMatch(each -> shardingRule.isGenerateKeyColumn(each.getIdentifier().getValue(), tableName));
    }

    private boolean isAllSameTables(Collection<String> tableNames) {
        return 1L == tableNames.stream().distinct().count();
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        Collection assignments;
        Optional<ShardingConditions> onDuplicateKeyShardingConditions;
        Optional<RouteContext> onDuplicateKeyRouteContext;
        InsertStatement insertStatement = (InsertStatement)sqlStatementContext.getSqlStatement();
        Optional insertSelect = insertStatement.getInsertSelect();
        String tableName = insertStatement.getTable().map(optional -> optional.getTableName().getIdentifier().getValue()).orElse("");
        if (insertSelect.isPresent() && this.shardingConditions.isNeedMerge()) {
            boolean singleRoutingOrSameShardingCondition = routeContext.isSingleRouting() || this.shardingConditions.isSameShardingCondition();
            ShardingSpherePreconditions.checkState((boolean)singleRoutingOrSameShardingCondition, () -> new UnsupportedShardingOperationException("INSERT ... SELECT ...", tableName));
        }
        if ((onDuplicateKeyRouteContext = (onDuplicateKeyShardingConditions = this.createShardingConditions(sqlStatementContext, shardingRule, assignments = (Collection)insertStatement.getOnDuplicateKeyColumns().map(OnDuplicateKeyColumnsSegment::getColumns).orElse(Collections.emptyList()), params)).map(optional -> new ShardingStandardRoutingEngine(tableName, (ShardingConditions)optional, sqlStatementContext, hintValueContext, props).route(shardingRule))).isPresent() && !this.isSameRouteContext(routeContext, onDuplicateKeyRouteContext.get())) {
            throw new UnsupportedUpdatingShardingValueException(tableName);
        }
        if (!routeContext.isSingleRouting()) {
            boolean isSingleDataNode = routeContext.getOriginalDataNodes().stream().allMatch(dataNodes -> 1 == dataNodes.size());
            ShardingSpherePreconditions.checkState((boolean)isSingleDataNode, () -> new DuplicateInsertDataRecordException(this.shardingConditions, tableName));
        }
    }

    @Generated
    public ShardingInsertStatementValidator(ShardingConditions shardingConditions) {
        this.shardingConditions = shardingConditions;
    }
}

