/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.frontend.ssl.SSLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxySSLContext {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxySSLContext.class);
    private static final ProxySSLContext INSTANCE = new ProxySSLContext();
    private SslContext sslContext;

    public static void init() throws SSLException {
        if (!((Boolean)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_SSL_ENABLED)).booleanValue()) {
            log.info("Proxy frontend SSL/TLS is not enabled.");
            return;
        }
        SslContextBuilder sslContextBuilder = ProxySSLContext.prepareSslContextBuilder();
        String versions = ((String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_SSL_VERSION)).trim();
        sslContextBuilder.protocols(versions.split(","));
        String ciphers = ((String)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.PROXY_FRONTEND_SSL_CIPHER)).trim();
        if (!ciphers.isEmpty()) {
            sslContextBuilder.ciphers(Arrays.asList(ciphers.split(",")));
        }
        ProxySSLContext.INSTANCE.sslContext = sslContextBuilder.build();
        log.info("Proxy frontend SSL/TLS is enabled. Supported protocols: {}", (Object)versions);
    }

    private static SslContextBuilder prepareSslContextBuilder() {
        KeyPair keyPair = SSLUtils.generateRSAKeyPair();
        X509Certificate x509Certificate = SSLUtils.generateSelfSignedX509Certificate(keyPair);
        SslContextBuilder result = SslContextBuilder.forServer((PrivateKey)keyPair.getPrivate(), (X509Certificate[])new X509Certificate[]{x509Certificate});
        log.warn("RSA key pair and CA certificate are generated by ShardingSphere-Proxy and self-signed.");
        return result;
    }

    public static ProxySSLContext getInstance() {
        return INSTANCE;
    }

    public boolean isSSLEnabled() {
        return null != this.sslContext;
    }

    public SSLEngine newSSLEngine(ByteBufAllocator allocator) {
        return this.sslContext.newEngine(allocator);
    }
}

