/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.datasource;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.checker.DialectPipelineDatabaseVariableChecker;
import org.apache.shardingsphere.infra.database.core.exception.CheckDatabaseEnvironmentFailedException;
import org.apache.shardingsphere.infra.database.core.exception.UnexpectedVariableValueException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class MySQLPipelineDatabaseVariableChecker
implements DialectPipelineDatabaseVariableChecker {
    private static final Map<String, String> REQUIRED_VARIABLES = new HashMap<String, String>(3, 1.0f);
    private static final String SHOW_VARIABLES_SQL;

    public void check(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(SHOW_VARIABLES_SQL);){
            int parameterIndex = 1;
            for (Map.Entry<String, String> entry : REQUIRED_VARIABLES.entrySet()) {
                preparedStatement.setString(parameterIndex++, entry.getKey());
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    String variableName = resultSet.getString(1).toUpperCase();
                    String expectedValue = REQUIRED_VARIABLES.get(variableName);
                    String actualValue = resultSet.getString(2);
                    ShardingSpherePreconditions.checkState((boolean)expectedValue.equalsIgnoreCase(actualValue), () -> new UnexpectedVariableValueException(variableName, expectedValue, actualValue));
                }
            }
        }
        catch (SQLException ex) {
            throw new CheckDatabaseEnvironmentFailedException(ex);
        }
    }

    public String getDatabaseType() {
        return "MySQL";
    }

    static {
        REQUIRED_VARIABLES.put("LOG_BIN", "ON");
        REQUIRED_VARIABLES.put("BINLOG_FORMAT", "ROW");
        REQUIRED_VARIABLES.put("BINLOG_ROW_IMAGE", "FULL");
        SHOW_VARIABLES_SQL = String.format("SHOW VARIABLES WHERE Variable_name IN (%s)", REQUIRED_VARIABLES.keySet().stream().map(each -> "?").collect(Collectors.joining(",")));
    }
}

