/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.subscriber.dispatch;

import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.process.Process;
import org.apache.shardingsphere.infra.executor.sql.process.ProcessRegistry;
import org.apache.shardingsphere.infra.executor.sql.process.lock.ProcessOperationLockRegistry;
import org.apache.shardingsphere.infra.executor.sql.process.yaml.swapper.YamlProcessListSwapper;
import org.apache.shardingsphere.infra.util.eventbus.EventSubscriber;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.metadata.persist.node.ProcessNode;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.KillLocalProcessCompletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.KillLocalProcessEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.ReportLocalProcessesCompletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.ReportLocalProcessesEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ProcessListChangedSubscriber
implements EventSubscriber {
    private final ContextManager contextManager;
    private final YamlProcessListSwapper swapper = new YamlProcessListSwapper();

    @Subscribe
    public void reportLocalProcesses(ReportLocalProcessesEvent event) {
        if (!event.getInstanceId().equals(this.contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId())) {
            return;
        }
        Collection processes = ProcessRegistry.getInstance().listAll();
        if (!processes.isEmpty()) {
            this.contextManager.getPersistServiceFacade().getRepository().persist(ProcessNode.getProcessListInstancePath((String)event.getTaskId(), (String)event.getInstanceId()), YamlEngine.marshal((Object)this.swapper.swapToYamlConfiguration(processes)));
        }
        this.contextManager.getPersistServiceFacade().getRepository().delete(ComputeNode.getProcessTriggerInstanceNodePath((String)event.getInstanceId(), (String)event.getTaskId()));
    }

    @Subscribe
    public synchronized void completeToReportLocalProcesses(ReportLocalProcessesCompletedEvent event) {
        ProcessOperationLockRegistry.getInstance().notify(event.getTaskId());
    }

    @Subscribe
    public synchronized void killLocalProcess(KillLocalProcessEvent event) throws SQLException {
        if (!event.getInstanceId().equals(this.contextManager.getComputeNodeInstanceContext().getInstance().getMetaData().getId())) {
            return;
        }
        Process process = ProcessRegistry.getInstance().get(event.getProcessId());
        if (null != process) {
            process.setInterrupted(true);
            for (Statement each : process.getProcessStatements().values()) {
                each.cancel();
            }
        }
        this.contextManager.getPersistServiceFacade().getRepository().delete(ComputeNode.getProcessKillInstanceIdNodePath((String)event.getInstanceId(), (String)event.getProcessId()));
    }

    @Subscribe
    public synchronized void completeToKillLocalProcess(KillLocalProcessCompletedEvent event) {
        ProcessOperationLockRegistry.getInstance().notify(event.getProcessId());
    }

    @Generated
    public ProcessListChangedSubscriber(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

