/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.persist.service;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeData;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataFactory;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeData;
import org.apache.shardingsphere.infra.instance.yaml.YamlComputeNodeDataSwapper;
import org.apache.shardingsphere.infra.state.instance.InstanceState;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.spi.PersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComputeNodePersistService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputeNodePersistService.class);
    private final PersistRepository repository;

    public void registerOnline(ComputeNodeInstance computeNodeInstance) {
        String instanceId = computeNodeInstance.getMetaData().getId();
        this.repository.persistEphemeral(ComputeNode.getOnlineInstanceNodePath((String)instanceId, (InstanceType)computeNodeInstance.getMetaData().getType()), YamlEngine.marshal((Object)new YamlComputeNodeDataSwapper().swapToYamlConfiguration(new ComputeNodeData(computeNodeInstance.getMetaData().getAttributes(), computeNodeInstance.getMetaData().getVersion()))));
        this.repository.persistEphemeral(ComputeNode.getComputeNodeStateNodePath((String)instanceId), computeNodeInstance.getState().getCurrentState().name());
        this.persistInstanceLabels(instanceId, computeNodeInstance.getLabels());
    }

    public void persistInstanceLabels(String instanceId, Collection<String> labels) {
        this.repository.persistEphemeral(ComputeNode.getInstanceLabelsNodePath((String)instanceId), YamlEngine.marshal(labels));
    }

    public void persistInstanceWorkerId(String instanceId, int workerId) {
        this.repository.persistEphemeral(ComputeNode.getInstanceWorkerIdNodePath((String)instanceId), String.valueOf(workerId));
    }

    public Collection<String> loadInstanceLabels(String instanceId) {
        String yamlContent = this.repository.query(ComputeNode.getInstanceLabelsNodePath((String)instanceId));
        return Strings.isNullOrEmpty((String)yamlContent) ? new LinkedList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
    }

    public String loadComputeNodeState(String instanceId) {
        return this.repository.query(ComputeNode.getComputeNodeStateNodePath((String)instanceId));
    }

    public Optional<Integer> loadInstanceWorkerId(String instanceId) {
        try {
            String workerId = this.repository.query(ComputeNode.getInstanceWorkerIdNodePath((String)instanceId));
            return Strings.isNullOrEmpty((String)workerId) ? Optional.empty() : Optional.of(Integer.valueOf(workerId));
        }
        catch (NumberFormatException ex) {
            log.error("Invalid worker id for instance: {}", (Object)instanceId);
            return Optional.empty();
        }
    }

    public Collection<ComputeNodeInstance> loadAllComputeNodeInstances() {
        return Arrays.stream(InstanceType.values()).flatMap(each -> this.loadComputeNodeInstances((InstanceType)each).stream()).collect(Collectors.toList());
    }

    private Collection<ComputeNodeInstance> loadComputeNodeInstances(InstanceType instanceType) {
        LinkedList<ComputeNodeInstance> result = new LinkedList<ComputeNodeInstance>();
        for (String each : this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath((InstanceType)instanceType))) {
            String value = this.repository.query(ComputeNode.getOnlineInstanceNodePath((String)each, (InstanceType)instanceType));
            if (Strings.isNullOrEmpty((String)value)) continue;
            ComputeNodeData computeNodeData = new YamlComputeNodeDataSwapper().swapToObject((YamlComputeNodeData)YamlEngine.unmarshal((String)value, YamlComputeNodeData.class));
            result.add(this.loadComputeNodeInstance(InstanceMetaDataFactory.create((String)each, (InstanceType)instanceType, (String)computeNodeData.getAttribute(), (String)computeNodeData.getVersion())));
        }
        return result;
    }

    public ComputeNodeInstance loadComputeNodeInstance(InstanceMetaData instanceMetaData) {
        ComputeNodeInstance result = new ComputeNodeInstance(instanceMetaData);
        result.getLabels().addAll(this.loadInstanceLabels(instanceMetaData.getId()));
        InstanceState.get((String)this.loadComputeNodeState(instanceMetaData.getId())).ifPresent(arg_0 -> ((ComputeNodeInstance)result).switchState(arg_0));
        this.loadInstanceWorkerId(instanceMetaData.getId()).ifPresent(arg_0 -> ((ComputeNodeInstance)result).setWorkerId(arg_0));
        return result;
    }

    public Collection<Integer> getAssignedWorkerIds() {
        List childrenKeys = this.repository.getChildrenKeys(ComputeNode.getInstanceWorkerIdRootNodePath());
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>(childrenKeys.size(), 1.0f);
        for (String each : childrenKeys) {
            String workerId = this.repository.query(ComputeNode.getInstanceWorkerIdNodePath((String)each));
            if (null == workerId) continue;
            result.add(Integer.parseInt(workerId));
        }
        return result;
    }

    public void updateComputeNodeState(String instanceId, InstanceState instanceState) {
        this.repository.persistEphemeral(ComputeNode.getComputeNodeStateNodePath((String)instanceId), instanceState.name());
    }

    public void offline(ComputeNodeInstance computeNodeInstance) {
        this.repository.delete(ComputeNode.getOnlineInstanceNodePath((String)computeNodeInstance.getMetaData().getId(), (InstanceType)computeNodeInstance.getMetaData().getType()));
    }

    @Generated
    public ComputeNodePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

