/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.scenario.migration.preparer;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.channel.IncrementalChannelCreator;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.checker.PipelineDataSourceCheckEngine;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextKey;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContextManager;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.context.TransmissionJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSource;
import org.apache.shardingsphere.data.pipeline.core.datasource.PipelineDataSourceManager;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobCancelingException;
import org.apache.shardingsphere.data.pipeline.core.exception.job.PrepareJobWithGetBinlogPositionException;
import org.apache.shardingsphere.data.pipeline.core.execute.PipelineExecuteEngine;
import org.apache.shardingsphere.data.pipeline.core.importer.SingleChannelConsumerImporter;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.Dumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.CreateIncrementalDumperParameter;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.DialectIncrementalDumperCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperCreator;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.InventoryDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.job.JobStatus;
import org.apache.shardingsphere.data.pipeline.core.job.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.preparer.PipelineJobPreparer;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobItemIncrementalTasksProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.JobOffsetInfo;
import org.apache.shardingsphere.data.pipeline.core.job.progress.TransmissionJobItemProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobProgressListener;
import org.apache.shardingsphere.data.pipeline.core.job.progress.yaml.swapper.YamlPipelineJobItemProgressSwapper;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.PipelineJobDataSourcePreparer;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.CreateTableConfiguration;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.PrepareTargetSchemasParameter;
import org.apache.shardingsphere.data.pipeline.core.preparer.datasource.param.PrepareTargetTablesParameter;
import org.apache.shardingsphere.data.pipeline.core.preparer.incremental.IncrementalTaskPositionManager;
import org.apache.shardingsphere.data.pipeline.core.preparer.inventory.splitter.InventoryTaskSplitter;
import org.apache.shardingsphere.data.pipeline.core.registrycenter.repository.job.PipelineJobOffsetGovernanceRepository;
import org.apache.shardingsphere.data.pipeline.core.task.IncrementalTask;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTask;
import org.apache.shardingsphere.data.pipeline.core.task.PipelineTaskUtils;
import org.apache.shardingsphere.data.pipeline.core.task.progress.IncrementalTaskProgress;
import org.apache.shardingsphere.data.pipeline.scenario.migration.MigrationJobType;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationJobConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.config.MigrationTaskConfiguration;
import org.apache.shardingsphere.data.pipeline.scenario.migration.context.MigrationJobItemContext;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.lock.GlobalLockNames;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.lock.LockDefinition;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.parser.SQLParserEngine;
import org.apache.shardingsphere.mode.lock.GlobalLockDefinition;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.parser.rule.SQLParserRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MigrationJobPreparer
implements PipelineJobPreparer<MigrationJobItemContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MigrationJobPreparer.class);
    private final PipelineJobItemManager<TransmissionJobItemProgress> jobItemManager = new PipelineJobItemManager((YamlPipelineJobItemProgressSwapper)new MigrationJobType().getYamlJobItemProgressSwapper());

    public void prepare(MigrationJobItemContext jobItemContext) throws SQLException {
        ShardingSpherePreconditions.checkState((boolean)StandardPipelineDataSourceConfiguration.class.equals(jobItemContext.getTaskConfig().getDumperContext().getCommonContext().getDataSourceConfig().getClass()), () -> new UnsupportedSQLOperationException("Migration inventory dumper only support StandardPipelineDataSourceConfiguration."));
        DatabaseType sourceDatabaseType = jobItemContext.getJobConfig().getSourceDatabaseType();
        new PipelineDataSourceCheckEngine(sourceDatabaseType).checkSourceDataSources(Collections.singleton(jobItemContext.getSourceDataSource()));
        ShardingSpherePreconditions.checkState((!jobItemContext.isStopping() ? 1 : 0) != 0, PipelineJobCancelingException::new);
        this.prepareAndCheckTargetWithLock(jobItemContext);
        ShardingSpherePreconditions.checkState((!jobItemContext.isStopping() ? 1 : 0) != 0, PipelineJobCancelingException::new);
        boolean isIncrementalSupported = DatabaseTypedSPILoader.findService(DialectIncrementalDumperCreator.class, (DatabaseType)sourceDatabaseType).isPresent();
        if (isIncrementalSupported) {
            this.prepareIncremental(jobItemContext);
        }
        this.initInventoryTasks(jobItemContext);
        if (isIncrementalSupported) {
            this.initIncrementalTasks(jobItemContext);
            ShardingSpherePreconditions.checkState((!jobItemContext.isStopping() ? 1 : 0) != 0, PipelineJobCancelingException::new);
        }
        log.info("Prepare job, jobId={}, shardingItem={}, inventoryTasks={}, incrementalTasks={}", new Object[]{jobItemContext.getJobId(), jobItemContext.getShardingItem(), jobItemContext.getInventoryTasks(), jobItemContext.getIncrementalTasks()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareAndCheckTargetWithLock(MigrationJobItemContext jobItemContext) throws SQLException {
        block5: {
            String jobId;
            block4: {
                long startTimeMillis;
                GlobalLockDefinition lockDefinition;
                LockContext lockContext;
                block3: {
                    MigrationJobConfiguration jobConfig = jobItemContext.getJobConfig();
                    jobId = jobConfig.getJobId();
                    PipelineContextKey contextKey = PipelineJobIdUtils.parseContextKey((String)jobId);
                    ContextManager contextManager = PipelineContextManager.getContext((PipelineContextKey)contextKey).getContextManager();
                    lockContext = contextManager.getComputeNodeInstanceContext().getLockContext();
                    if (!this.jobItemManager.getProgress(jobId, jobItemContext.getShardingItem()).isPresent()) {
                        this.jobItemManager.persistProgress((PipelineJobItemContext)jobItemContext);
                    }
                    lockDefinition = new GlobalLockDefinition(String.format(GlobalLockNames.PREPARE.getLockName(), jobConfig.getJobId()));
                    startTimeMillis = System.currentTimeMillis();
                    if (!lockContext.tryLock((LockDefinition)lockDefinition, 600000L)) break block4;
                    log.info("Lock success, jobId={}, shardingItem={}, cost {} ms.", new Object[]{jobId, jobItemContext.getShardingItem(), System.currentTimeMillis() - startTimeMillis});
                    try {
                        PipelineJobOffsetGovernanceRepository offsetRepository = PipelineAPIFactory.getPipelineGovernanceFacade((PipelineContextKey)contextKey).getJobFacade().getOffset();
                        JobOffsetInfo offsetInfo = offsetRepository.load(jobId);
                        if (offsetInfo.isTargetSchemaTableCreated()) break block3;
                        jobItemContext.setStatus(JobStatus.PREPARING);
                        this.jobItemManager.updateStatus(jobId, jobItemContext.getShardingItem(), JobStatus.PREPARING);
                        this.prepareAndCheckTarget(jobItemContext, contextManager);
                        offsetRepository.persist(jobId, new JobOffsetInfo(true));
                    }
                    catch (Throwable throwable) {
                        log.info("Unlock, jobId={}, shardingItem={}, cost {} ms.", new Object[]{jobId, jobItemContext.getShardingItem(), System.currentTimeMillis() - startTimeMillis});
                        lockContext.unlock((LockDefinition)lockDefinition);
                        throw throwable;
                    }
                }
                log.info("Unlock, jobId={}, shardingItem={}, cost {} ms.", new Object[]{jobId, jobItemContext.getShardingItem(), System.currentTimeMillis() - startTimeMillis});
                lockContext.unlock((LockDefinition)lockDefinition);
                break block5;
            }
            log.warn("Lock failed, jobId={}, shardingItem={}.", (Object)jobId, (Object)jobItemContext.getShardingItem());
        }
    }

    private void prepareAndCheckTarget(MigrationJobItemContext jobItemContext, ContextManager contextManager) throws SQLException {
        DatabaseType targetDatabaseType = jobItemContext.getJobConfig().getTargetDatabaseType();
        if (jobItemContext.isSourceTargetDatabaseTheSame()) {
            this.prepareTarget(jobItemContext, targetDatabaseType, contextManager);
        }
        if (null == jobItemContext.getInitProgress()) {
            PipelineDataSource targetDataSource = jobItemContext.getDataSourceManager().getDataSource(jobItemContext.getTaskConfig().getImporterConfig().getDataSourceConfig());
            new PipelineDataSourceCheckEngine(targetDatabaseType).checkTargetDataSources(Collections.singleton(targetDataSource), jobItemContext.getTaskConfig().getImporterConfig());
        }
    }

    private void prepareTarget(MigrationJobItemContext jobItemContext, DatabaseType targetDatabaseType, ContextManager contextManager) throws SQLException {
        MigrationJobConfiguration jobConfig = jobItemContext.getJobConfig();
        Collection<CreateTableConfiguration> createTableConfigs = jobItemContext.getTaskConfig().getCreateTableConfigurations();
        PipelineDataSourceManager dataSourceManager = jobItemContext.getDataSourceManager();
        PipelineJobDataSourcePreparer preparer = new PipelineJobDataSourcePreparer(targetDatabaseType);
        preparer.prepareTargetSchemas(new PrepareTargetSchemasParameter(targetDatabaseType, createTableConfigs, dataSourceManager));
        ShardingSphereMetaData metaData = contextManager.getMetaDataContexts().getMetaData();
        SQLParserEngine sqlParserEngine = ((SQLParserRule)metaData.getGlobalRuleMetaData().getSingleRule(SQLParserRule.class)).getSQLParserEngine(metaData.getDatabase(jobConfig.getTargetDatabaseName()).getProtocolType());
        preparer.prepareTargetTables(new PrepareTargetTablesParameter(createTableConfigs, dataSourceManager, sqlParserEngine));
    }

    private void prepareIncremental(MigrationJobItemContext jobItemContext) {
        MigrationTaskConfiguration taskConfig = jobItemContext.getTaskConfig();
        JobItemIncrementalTasksProgress initIncremental = null == jobItemContext.getInitProgress() ? null : jobItemContext.getInitProgress().getIncremental();
        try {
            DatabaseType databaseType = taskConfig.getDumperContext().getCommonContext().getDataSourceConfig().getDatabaseType();
            IngestPosition position = new IncrementalTaskPositionManager(databaseType).getPosition(initIncremental, taskConfig.getDumperContext(), jobItemContext.getDataSourceManager());
            taskConfig.getDumperContext().getCommonContext().setPosition(position);
        }
        catch (SQLException ex) {
            throw new PrepareJobWithGetBinlogPositionException(jobItemContext.getJobId(), ex);
        }
    }

    private void initInventoryTasks(MigrationJobItemContext jobItemContext) {
        InventoryDumperContext inventoryDumperContext = new InventoryDumperContext(jobItemContext.getTaskConfig().getDumperContext().getCommonContext());
        InventoryTaskSplitter inventoryTaskSplitter = new InventoryTaskSplitter(jobItemContext.getSourceDataSource(), inventoryDumperContext, jobItemContext.getTaskConfig().getImporterConfig());
        jobItemContext.getInventoryTasks().addAll(inventoryTaskSplitter.split((TransmissionJobItemContext)jobItemContext));
    }

    private void initIncrementalTasks(MigrationJobItemContext jobItemContext) {
        MigrationTaskConfiguration taskConfig = jobItemContext.getTaskConfig();
        IncrementalDumperContext dumperContext = taskConfig.getDumperContext();
        PipelineExecuteEngine incrementalExecuteEngine = jobItemContext.getJobProcessContext().getIncrementalExecuteEngine();
        IncrementalTaskProgress taskProgress = PipelineTaskUtils.createIncrementalTaskProgress((IngestPosition)dumperContext.getCommonContext().getPosition(), (TransmissionJobItemProgress)jobItemContext.getInitProgress());
        PipelineChannel channel = IncrementalChannelCreator.create((AlgorithmConfiguration)jobItemContext.getJobProcessContext().getProcessConfiguration().getStreamChannel(), (IncrementalTaskProgress)taskProgress);
        CreateIncrementalDumperParameter param = new CreateIncrementalDumperParameter(dumperContext, dumperContext.getCommonContext().getPosition(), channel, jobItemContext.getSourceMetaDataLoader(), jobItemContext.getDataSourceManager());
        IncrementalDumper dumper = IncrementalDumperCreator.create((CreateIncrementalDumperParameter)param);
        List<SingleChannelConsumerImporter> importers = Collections.singletonList(new SingleChannelConsumerImporter(channel, 1, 5L, jobItemContext.getSink(), (PipelineJobProgressListener)jobItemContext));
        IncrementalTask incrementalTask = new IncrementalTask(dumperContext.getCommonContext().getDataSourceName(), incrementalExecuteEngine, (Dumper)dumper, importers, taskProgress);
        jobItemContext.getIncrementalTasks().add((PipelineTask)incrementalTask);
    }
}

