/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.core.spi;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shardingsphere.agent.plugin.core.preconditions.PluginPreconditions;
import org.apache.shardingsphere.agent.plugin.core.spi.PluginTypedSPI;

public final class PluginServiceLoader<T> {
    private static final Map<Class<?>, PluginServiceLoader<?>> LOADERS = new ConcurrentHashMap();
    private final Collection<T> services;

    private PluginServiceLoader(Class<T> service) {
        PluginPreconditions.checkArgument(service.isInterface(), String.format("SPI class `%s` is not interface.", service));
        this.services = this.load(service);
    }

    private Collection<T> load(Class<T> service) {
        LinkedList<T> result = new LinkedList<T>();
        for (T each : ServiceLoader.load(service)) {
            result.add(each);
        }
        return result;
    }

    public static <T extends PluginTypedSPI> PluginServiceLoader<T> getServiceLoader(Class<T> service) {
        return LOADERS.computeIfAbsent(service, PluginServiceLoader::new);
    }

    public T getService(String pluginType) {
        return (T)this.services.stream().filter(each -> pluginType.equalsIgnoreCase(((PluginTypedSPI)each).getType())).findFirst().orElseThrow(() -> new UnsupportedOperationException(pluginType));
    }
}

