/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node.path.metadata;

import lombok.Generated;

public final class DatabaseRuleMetaDataNodePath {
    private static final String ROOT_NODE = "/metadata";
    private static final String RULE_NODE = "rules";
    private static final String VERSIONS_NODE = "versions";
    private static final String ACTIVE_VERSION_NODE = "active_version";

    public static String getRootPath(String databaseName) {
        return String.join((CharSequence)"/", ROOT_NODE, databaseName, RULE_NODE);
    }

    public static String getRulePath(String databaseName, String ruleTypeName) {
        return String.join((CharSequence)"/", DatabaseRuleMetaDataNodePath.getRootPath(databaseName), ruleTypeName);
    }

    public static String getRulePath(String databaseName, String ruleTypeName, String key) {
        return String.join((CharSequence)"/", DatabaseRuleMetaDataNodePath.getRulePath(databaseName, ruleTypeName), key);
    }

    public static String getVersionsPath(String databaseName, String ruleTypeName, String key) {
        return String.join((CharSequence)"/", DatabaseRuleMetaDataNodePath.getRulePath(databaseName, ruleTypeName, key), VERSIONS_NODE);
    }

    public static String getVersionPath(String databaseName, String ruleTypeName, String key, String version) {
        return String.join((CharSequence)"/", DatabaseRuleMetaDataNodePath.getVersionsPath(databaseName, ruleTypeName, key), version);
    }

    public static String getActiveVersionPath(String databaseName, String ruleTypeName, String key) {
        return String.join((CharSequence)"/", DatabaseRuleMetaDataNodePath.getRulePath(databaseName, ruleTypeName, key), ACTIVE_VERSION_NODE);
    }

    @Generated
    private DatabaseRuleMetaDataNodePath() {
    }
}

