/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.standalone.persist.service;

import com.google.common.base.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaPOJO;
import org.apache.shardingsphere.infra.metadata.version.MetaDataVersion;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.infra.rule.scope.GlobalRule;
import org.apache.shardingsphere.infra.spi.type.ordered.cache.OrderedServicesCache;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.metadata.MetaDataContextManager;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.manager.RuleItemChangedBuilder;
import org.apache.shardingsphere.mode.metadata.manager.SwitchingResource;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.config.database.DataSourceUnitPersistService;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;
import org.apache.shardingsphere.mode.spi.rule.item.RuleChangedItem;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;
import org.apache.shardingsphere.single.config.SingleRuleConfiguration;

public final class StandaloneMetaDataManagerPersistService
implements MetaDataManagerPersistService {
    private final MetaDataPersistService metaDataPersistService;
    private final MetaDataContextManager metaDataContextManager;
    private final RuleItemChangedBuilder ruleItemChangedBuilder;

    public StandaloneMetaDataManagerPersistService(PersistRepository repository, MetaDataContextManager metaDataContextManager) {
        this.metaDataPersistService = new MetaDataPersistService(repository);
        this.metaDataContextManager = metaDataContextManager;
        this.ruleItemChangedBuilder = new RuleItemChangedBuilder();
    }

    public void createDatabase(String databaseName) {
        this.metaDataContextManager.getSchemaMetaDataManager().addDatabase(databaseName);
        this.metaDataPersistService.getDatabaseMetaDataFacade().getDatabase().add(databaseName);
        this.clearServiceCache();
    }

    public void dropDatabase(String databaseName) {
        this.metaDataContextManager.getSchemaMetaDataManager().dropDatabase(databaseName);
        this.metaDataPersistService.getDatabaseMetaDataFacade().getDatabase().drop(databaseName);
        this.clearServiceCache();
    }

    public void createSchema(String databaseName, String schemaName) {
        ShardingSphereMetaData metaData = this.metaDataContextManager.getMetaDataContexts().getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        database.addSchema(new ShardingSphereSchema(schemaName));
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().add(databaseName, schemaName);
    }

    public void alterSchema(AlterSchemaPOJO alterSchemaPOJO) {
        ShardingSphereMetaData metaData = this.metaDataContextManager.getMetaDataContexts().getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(alterSchemaPOJO.getDatabaseName());
        this.putSchemaMetaData(database, alterSchemaPOJO.getSchemaName(), alterSchemaPOJO.getRenameSchemaName(), alterSchemaPOJO.getLogicDataSourceName());
        this.removeSchemaMetaData(database, alterSchemaPOJO.getSchemaName());
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        ShardingSphereSchema alteredSchema = database.getSchema(alterSchemaPOJO.getRenameSchemaName());
        String databaseName = alterSchemaPOJO.getDatabaseName();
        String alteredSchemaName = alterSchemaPOJO.getRenameSchemaName();
        if (alteredSchema.isEmpty()) {
            this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().add(databaseName, alteredSchemaName);
        }
        this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, alteredSchemaName, alteredSchema.getAllTables());
        this.metaDataPersistService.getDatabaseMetaDataFacade().getView().persist(databaseName, alteredSchemaName, alteredSchema.getAllViews());
        this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().drop(databaseName, alterSchemaPOJO.getSchemaName());
    }

    private void putSchemaMetaData(ShardingSphereDatabase database, String schemaName, String renamedSchemaName, String logicDataSourceName) {
        ShardingSphereSchema schema = database.getSchema(schemaName);
        ShardingSphereSchema renamedSchema = new ShardingSphereSchema(renamedSchemaName, schema.getAllTables(), schema.getAllViews());
        database.addSchema(renamedSchema);
        this.addDataNode(database, logicDataSourceName, schemaName, schema.getAllTables());
    }

    private void addDataNode(ShardingSphereDatabase database, String logicDataSourceName, String schemaName, Collection<ShardingSphereTable> tobeAddedTables) {
        for (ShardingSphereTable each : tobeAddedTables) {
            if (Strings.isNullOrEmpty((String)logicDataSourceName) || !TableRefreshUtils.isSingleTable((String)each.getName(), (ShardingSphereDatabase)database)) continue;
            database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(rule -> rule.put(logicDataSourceName, schemaName, each.getName()));
        }
    }

    private void addDataNode(ShardingSphereDatabase database, String logicDataSourceName, String schemaName, Collection<ShardingSphereTable> toBeAddedTables, Collection<ShardingSphereView> toBeAddedViews) {
        this.addTablesToDataNode(database, schemaName, logicDataSourceName, toBeAddedTables);
        this.addViewsToDataNode(database, schemaName, logicDataSourceName, toBeAddedTables, toBeAddedViews);
    }

    private void addTablesToDataNode(ShardingSphereDatabase database, String schemaName, String logicDataSourceName, Collection<ShardingSphereTable> toBeAddedTables) {
        for (ShardingSphereTable each : toBeAddedTables) {
            if (!Strings.isNullOrEmpty((String)logicDataSourceName) && TableRefreshUtils.isSingleTable((String)each.getName(), (ShardingSphereDatabase)database)) {
                database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(rule -> rule.put(logicDataSourceName, schemaName, each.getName()));
            }
            database.getSchema(schemaName).putTable(each);
        }
    }

    private void addViewsToDataNode(ShardingSphereDatabase database, String schemaName, String logicDataSourceName, Collection<ShardingSphereTable> toBeAddedTables, Collection<ShardingSphereView> toBeAddedViews) {
        for (ShardingSphereView view : toBeAddedViews) {
            if (!Strings.isNullOrEmpty((String)logicDataSourceName) && TableRefreshUtils.isSingleTable((String)view.getName(), (ShardingSphereDatabase)database)) {
                database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.put(logicDataSourceName, schemaName, view.getName()));
            }
            toBeAddedTables.stream().filter(each -> each.getName().toLowerCase().equals(view.getName())).findFirst().ifPresent(optional -> database.getSchema(schemaName).putTable(optional));
            database.getSchema(schemaName).putView(view);
        }
    }

    private void removeSchemaMetaData(ShardingSphereDatabase database, String schemaName) {
        ShardingSphereSchema schema = new ShardingSphereSchema(schemaName, database.getSchema(schemaName).getAllTables(), database.getSchema(schemaName).getAllViews());
        database.dropSchema(schemaName);
        this.removeDataNode((Collection<MutableDataNodeRuleAttribute>)database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class), Collections.singleton(schemaName), (Collection<String>)schema.getAllTables().stream().map(ShardingSphereTable::getName).collect(Collectors.toSet()));
    }

    private void removeDataNode(Collection<MutableDataNodeRuleAttribute> ruleAttributes, Collection<String> schemaNames, Collection<String> tobeRemovedTables) {
        tobeRemovedTables.forEach(each -> ruleAttributes.forEach(rule -> rule.remove(schemaNames, each)));
    }

    private void removeDataNode(ShardingSphereDatabase database, String schemaName, Collection<String> tobeRemovedTables, Collection<String> tobeRemovedViews) {
        this.removeTablesToDataNode(database, schemaName, tobeRemovedTables);
        this.removeViewsToDataNode(database, schemaName, tobeRemovedTables, tobeRemovedViews);
    }

    private void removeDataNode(Collection<MutableDataNodeRuleAttribute> ruleAttributes, String schemaName, Collection<String> tobeRemovedTables) {
        tobeRemovedTables.forEach(each -> ruleAttributes.forEach(rule -> rule.remove(schemaName, each)));
    }

    private void removeTablesToDataNode(ShardingSphereDatabase database, String schemaName, Collection<String> toBeDroppedTables) {
        this.removeDataNode((Collection<MutableDataNodeRuleAttribute>)database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class), schemaName, toBeDroppedTables);
        toBeDroppedTables.forEach(each -> database.getSchema(schemaName).removeTable(each));
    }

    private void removeViewsToDataNode(ShardingSphereDatabase database, String schemaName, Collection<String> toBeDroppedTables, Collection<String> toBeDroppedViews) {
        this.removeDataNode((Collection<MutableDataNodeRuleAttribute>)database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class), schemaName, toBeDroppedViews);
        ShardingSphereSchema schema = database.getSchema(schemaName);
        toBeDroppedTables.forEach(arg_0 -> ((ShardingSphereSchema)schema).removeTable(arg_0));
        toBeDroppedViews.forEach(arg_0 -> ((ShardingSphereSchema)schema).removeView(arg_0));
    }

    public void dropSchema(String databaseName, Collection<String> schemaNames) {
        LinkedList tobeRemovedTables = new LinkedList();
        LinkedList<String> tobeRemovedSchemas = new LinkedList<String>();
        ShardingSphereMetaData metaData = this.metaDataContextManager.getMetaDataContexts().getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        for (String each2 : schemaNames) {
            ShardingSphereSchema schema = new ShardingSphereSchema(each2, database.getSchema(each2).getAllTables(), database.getSchema(each2).getAllViews());
            database.dropSchema(each2);
            Optional.of(schema).ifPresent(optional -> tobeRemovedTables.addAll(optional.getAllTables().stream().map(ShardingSphereTable::getName).collect(Collectors.toSet())));
            tobeRemovedSchemas.add(each2.toLowerCase());
        }
        this.removeDataNode((Collection<MutableDataNodeRuleAttribute>)database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class), new HashSet<String>(tobeRemovedSchemas), new HashSet<String>(tobeRemovedTables));
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
    }

    public void alterSchemaMetaData(AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO) {
        String databaseName = alterSchemaMetaDataPOJO.getDatabaseName();
        String schemaName = alterSchemaMetaDataPOJO.getSchemaName();
        ShardingSphereMetaData metaData = this.metaDataContextManager.getMetaDataContexts().getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        this.addDataNode(database, alterSchemaMetaDataPOJO.getLogicDataSourceName(), schemaName, alterSchemaMetaDataPOJO.getAlteredTables(), alterSchemaMetaDataPOJO.getAlteredViews());
        this.removeDataNode(database, schemaName, alterSchemaMetaDataPOJO.getDroppedTables(), alterSchemaMetaDataPOJO.getDroppedViews());
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, schemaName, alterSchemaMetaDataPOJO.getAlteredTables());
        this.metaDataPersistService.getDatabaseMetaDataFacade().getView().persist(databaseName, schemaName, alterSchemaMetaDataPOJO.getAlteredViews());
        alterSchemaMetaDataPOJO.getDroppedTables().forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().drop(databaseName, schemaName, each));
        alterSchemaMetaDataPOJO.getDroppedViews().forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getView().delete(databaseName, schemaName, each));
    }

    public void registerStorageUnits(String databaseName, Map<String, DataSourcePoolProperties> toBeRegisteredProps) throws SQLException {
        SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().switchByRegisterStorageUnit(this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeRegisteredProps);
        ShardingSphereDatabase changedDatabase = MetaDataContextsFactory.createChangedDatabase((String)databaseName, (boolean)false, (SwitchingResource)switchingResource, null, (MetaDataContexts)this.metaDataContextManager.getMetaDataContexts(), (MetaDataPersistService)this.metaDataPersistService, (ComputeNodeInstanceContext)this.metaDataContextManager.getComputeNodeInstanceContext());
        this.metaDataContextManager.getMetaDataContexts().getMetaData().putDatabase(changedDatabase);
        this.metaDataContextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(this.metaDataContextManager.getMetaDataContexts().getMetaData().getAllDatabases(), GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED));
        this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getAllSchemas().forEach(each -> {
            if (each.isEmpty()) {
                this.metaDataPersistService.getDatabaseMetaDataFacade().getSchema().add(databaseName, each.getName());
            }
            this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, each.getName(), each.getAllTables());
        });
        DataSourceUnitPersistService dataSourceService = this.metaDataPersistService.getDataSourceUnitService();
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(dataSourceService.persist(databaseName, toBeRegisteredProps));
        this.clearServiceCache();
    }

    public void alterStorageUnits(String databaseName, Map<String, DataSourcePoolProperties> toBeUpdatedProps) throws SQLException {
        SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().switchByAlterStorageUnit(this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeUpdatedProps);
        ShardingSphereDatabase changedDatabase = MetaDataContextsFactory.createChangedDatabase((String)databaseName, (boolean)true, (SwitchingResource)switchingResource, null, (MetaDataContexts)this.metaDataContextManager.getMetaDataContexts(), (MetaDataPersistService)this.metaDataPersistService, (ComputeNodeInstanceContext)this.metaDataContextManager.getComputeNodeInstanceContext());
        this.metaDataContextManager.getMetaDataContexts().getMetaData().putDatabase(changedDatabase);
        this.metaDataContextManager.getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(this.metaDataContextManager.getMetaDataContexts().getMetaData().getAllDatabases(), GlobalRule.GlobalRuleChangedType.DATABASE_CHANGED));
        DataSourceUnitPersistService dataSourceService = this.metaDataPersistService.getDataSourceUnitService();
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(dataSourceService.persist(databaseName, toBeUpdatedProps));
        switchingResource.closeStaleDataSources();
        this.clearServiceCache();
    }

    public void unregisterStorageUnits(String databaseName, Collection<String> toBeDroppedStorageUnitNames) throws SQLException {
        SwitchingResource switchingResource = this.metaDataContextManager.getResourceSwitchManager().switchByUnregisterStorageUnit(this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getResourceMetaData(), toBeDroppedStorageUnitNames);
        MetaDataContexts reloadMetaDataContexts = MetaDataContextsFactory.createBySwitchResource((String)databaseName, (boolean)false, (SwitchingResource)switchingResource, (MetaDataContexts)this.metaDataContextManager.getMetaDataContexts(), (MetaDataPersistService)this.metaDataPersistService, (ComputeNodeInstanceContext)this.metaDataContextManager.getComputeNodeInstanceContext());
        this.metaDataPersistService.persistReloadDatabaseByDrop(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName));
        this.metaDataContextManager.dropSchemas(databaseName, reloadMetaDataContexts.getMetaData().getDatabase(databaseName), this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName));
        this.metaDataContextManager.renewMetaDataContexts(reloadMetaDataContexts);
        switchingResource.closeStaleDataSources();
        this.clearServiceCache();
    }

    public void alterSingleRuleConfiguration(String databaseName, Collection<RuleConfiguration> ruleConfigs) throws SQLException {
        ruleConfigs.removeIf(each -> !each.getClass().isAssignableFrom(SingleRuleConfiguration.class));
        Collection metaDataVersions = this.metaDataPersistService.getDatabaseRulePersistService().persist(this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getName(), ruleConfigs);
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(metaDataVersions);
        this.metaDataContextManager.getDatabaseRuleConfigurationManager().alterRuleConfiguration(databaseName, ruleConfigs.iterator().next());
        this.clearServiceCache();
    }

    public void alterRuleConfiguration(String databaseName, RuleConfiguration toBeAlteredRuleConfig) throws SQLException {
        if (null == toBeAlteredRuleConfig) {
            return;
        }
        Collection metaDataVersions = this.metaDataPersistService.getDatabaseRulePersistService().persist(this.metaDataContextManager.getMetaDataContexts().getMetaData().getDatabase(databaseName).getName(), Collections.singleton(toBeAlteredRuleConfig));
        this.metaDataPersistService.getMetaDataVersionPersistService().switchActiveVersion(metaDataVersions);
        for (MetaDataVersion each : metaDataVersions) {
            Optional<RuleChangedItem> ruleItemChanged = this.buildAlterRuleItemChanged(databaseName, each, DataChangedEvent.Type.UPDATED);
            if (!ruleItemChanged.isPresent() || !(ruleItemChanged.get() instanceof AlterRuleItem)) continue;
            this.metaDataContextManager.getRuleItemManager().alterRuleItem((AlterRuleItem)ruleItemChanged.get());
        }
        this.clearServiceCache();
    }

    private Optional<RuleChangedItem> buildAlterRuleItemChanged(String databaseName, MetaDataVersion metaDataVersion, DataChangedEvent.Type type) {
        return this.ruleItemChangedBuilder.build(databaseName, metaDataVersion.getActiveVersionNodePath(), metaDataVersion.getNextActiveVersion(), type);
    }

    public void removeRuleConfigurationItem(String databaseName, RuleConfiguration toBeRemovedRuleConfig) throws SQLException {
        if (null == toBeRemovedRuleConfig) {
            return;
        }
        Collection metaDataVersions = this.metaDataPersistService.getDatabaseRulePersistService().delete(databaseName, Collections.singleton(toBeRemovedRuleConfig));
        for (MetaDataVersion metaDataVersion : metaDataVersions) {
            Optional<RuleChangedItem> ruleItemChanged = this.buildAlterRuleItemChanged(databaseName, metaDataVersion, DataChangedEvent.Type.DELETED);
            if (!ruleItemChanged.isPresent() || !(ruleItemChanged.get() instanceof DropRuleItem)) continue;
            this.metaDataContextManager.getRuleItemManager().dropRuleItem((DropRuleItem)ruleItemChanged.get());
        }
        this.clearServiceCache();
    }

    public void removeRuleConfiguration(String databaseName, String ruleName) {
        this.metaDataPersistService.getDatabaseRulePersistService().delete(databaseName, ruleName);
        this.clearServiceCache();
    }

    public void alterGlobalRuleConfiguration(RuleConfiguration toBeAlteredRuleConfig) {
        this.metaDataContextManager.getGlobalConfigurationManager().alterGlobalRuleConfiguration(toBeAlteredRuleConfig);
        this.metaDataPersistService.getGlobalRuleService().persist(Collections.singleton(toBeAlteredRuleConfig));
        this.clearServiceCache();
    }

    public void alterProperties(Properties props) {
        this.metaDataContextManager.getGlobalConfigurationManager().alterProperties(props);
        this.metaDataPersistService.getPropsService().persist(props);
        this.clearServiceCache();
    }

    public void createTable(String databaseName, String schemaName, ShardingSphereTable table, String logicDataSourceName) {
        ShardingSphereMetaData metaData = this.metaDataContextManager.getMetaDataContexts().getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        this.addTableToDataNode(database, schemaName, logicDataSourceName, table);
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().persist(databaseName, schemaName, Collections.singleton(table));
    }

    public void dropTables(String databaseName, String schemaName, Collection<String> tableNames) {
        ShardingSphereMetaData metaData = this.metaDataContextManager.getMetaDataContexts().getMetaData();
        ShardingSphereDatabase database = metaData.getDatabase(databaseName);
        this.removeTablesToDataNode(database, schemaName, tableNames);
        metaData.getGlobalRuleMetaData().getRules().forEach(each -> ((GlobalRule)each).refresh(metaData.getAllDatabases(), GlobalRule.GlobalRuleChangedType.SCHEMA_CHANGED));
        tableNames.forEach(each -> this.metaDataPersistService.getDatabaseMetaDataFacade().getTable().drop(databaseName, schemaName, each));
    }

    private void addTableToDataNode(ShardingSphereDatabase database, String schemaName, String logicDataSourceName, ShardingSphereTable table) {
        if (!Strings.isNullOrEmpty((String)logicDataSourceName) && TableRefreshUtils.isSingleTable((String)table.getName(), (ShardingSphereDatabase)database)) {
            database.getRuleMetaData().getAttributes(MutableDataNodeRuleAttribute.class).forEach(rule -> rule.put(logicDataSourceName, schemaName, table.getName()));
        }
        database.getSchema(schemaName).putTable(table);
    }

    private void clearServiceCache() {
        OrderedServicesCache.clearCache();
    }
}

