/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.type;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.engine.segment.dml.from.context.TableSegmentBinderContext;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ShorthandProjectionSegment;

public final class SimpleTableSegmentBinderContext
implements TableSegmentBinderContext {
    private final Map<String, ProjectionSegment> columnLabelProjectionSegments;

    public SimpleTableSegmentBinderContext(Collection<ProjectionSegment> projectionSegments) {
        this.columnLabelProjectionSegments = new CaseInsensitiveMap(projectionSegments.size(), 1.0f);
        projectionSegments.forEach(each -> this.putColumnLabelProjectionSegments((ProjectionSegment)each, this.columnLabelProjectionSegments));
    }

    private void putColumnLabelProjectionSegments(ProjectionSegment projectionSegment, Map<String, ProjectionSegment> columnLabelProjectionSegments) {
        if (projectionSegment instanceof ShorthandProjectionSegment) {
            ((ShorthandProjectionSegment)projectionSegment).getActualProjectionSegments().forEach(each -> columnLabelProjectionSegments.put(each.getColumnLabel(), (ProjectionSegment)each));
        } else {
            columnLabelProjectionSegments.put(projectionSegment.getColumnLabel(), projectionSegment);
        }
    }

    @Override
    public Optional<ProjectionSegment> findProjectionSegmentByColumnLabel(String columnLabel) {
        return Optional.ofNullable(this.columnLabelProjectionSegments.get(columnLabel));
    }

    @Override
    public Collection<ProjectionSegment> getProjectionSegments() {
        return this.columnLabelProjectionSegments.values();
    }

    @Generated
    public SimpleTableSegmentBinderContext(Map<String, ProjectionSegment> columnLabelProjectionSegments) {
        this.columnLabelProjectionSegments = columnLabelProjectionSegments;
    }
}

