/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.type.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.kernel.metadata.SchemaNotFoundException;
import org.apache.shardingsphere.infra.exception.kernel.metadata.TableNotFoundException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.pojo.AlterSchemaMetaDataPOJO;
import org.apache.shardingsphere.infra.metadata.database.schema.util.IndexMetaDataUtils;
import org.apache.shardingsphere.mode.metadata.refresher.MetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.divided.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropIndexStatement;

public final class DropIndexStatementSchemaRefresher
implements MetaDataRefresher<DropIndexStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, Collection<String> logicDataSourceNames, String schemaName, DatabaseType databaseType, DropIndexStatement sqlStatement, ConfigurationProperties props) {
        for (IndexSegment each : sqlStatement.getIndexes()) {
            String actualSchemaName = each.getOwner().map(optional -> optional.getIdentifier().getValue().toLowerCase()).orElse(schemaName);
            Optional<String> logicTableName = this.findLogicTableName(database, sqlStatement, Collections.singletonList(each));
            if (!logicTableName.isPresent()) continue;
            ShardingSpherePreconditions.checkState((boolean)database.containsSchema(actualSchemaName), () -> new SchemaNotFoundException(schemaName));
            ShardingSphereSchema schema = database.getSchema(actualSchemaName);
            ShardingSpherePreconditions.checkState((boolean)schema.containsTable(logicTableName.get()), () -> new TableNotFoundException((String)logicTableName.get()));
            ShardingSphereTable table = schema.getTable(logicTableName.get());
            ShardingSphereTable newTable = new ShardingSphereTable(table.getName(), table.getAllColumns(), table.getAllIndexes(), table.getAllConstraints(), table.getType());
            newTable.removeIndex(each.getIndexName().getIdentifier().getValue());
            AlterSchemaMetaDataPOJO alterSchemaMetaDataPOJO = new AlterSchemaMetaDataPOJO(database.getName(), actualSchemaName);
            alterSchemaMetaDataPOJO.getAlteredTables().add(newTable);
            metaDataManagerPersistService.alterSchemaMetaData(alterSchemaMetaDataPOJO);
        }
    }

    private Optional<String> findLogicTableName(ShardingSphereDatabase database, DropIndexStatement sqlStatement, Collection<IndexSegment> indexSegments) {
        Optional simpleTableSegment = sqlStatement.getSimpleTable();
        if (simpleTableSegment.isPresent()) {
            return Optional.of(((SimpleTableSegment)simpleTableSegment.get()).getTableName().getIdentifier().getValue());
        }
        Collection tableNames = IndexMetaDataUtils.getTableNames((ShardingSphereDatabase)database, (DatabaseType)database.getProtocolType(), indexSegments);
        return tableNames.isEmpty() ? Optional.empty() : Optional.of(((QualifiedTable)tableNames.iterator().next()).getTableName());
    }

    @Override
    public Class<DropIndexStatement> getType() {
        return DropIndexStatement.class;
    }
}

