/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.orderby;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.orderby.OrderByItem;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.sharding.exception.data.NotImplementComparableValueException;
import org.apache.shardingsphere.sharding.merge.dql.orderby.CompareUtils;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;

public final class OrderByValue
implements Comparable<OrderByValue> {
    private final QueryResult queryResult;
    private final Collection<OrderByItem> orderByItems;
    private final List<Boolean> orderValuesCaseSensitive;
    private final SelectStatementContext selectStatementContext;
    private List<Comparable<?>> orderValues;

    public OrderByValue(QueryResult queryResult, Collection<OrderByItem> orderByItems, SelectStatementContext selectStatementContext, ShardingSphereSchema schema) throws SQLException {
        this.queryResult = queryResult;
        this.orderByItems = orderByItems;
        this.selectStatementContext = selectStatementContext;
        this.orderValuesCaseSensitive = this.getOrderValuesCaseSensitive(schema);
    }

    private List<Boolean> getOrderValuesCaseSensitive(ShardingSphereSchema schema) throws SQLException {
        ArrayList<Boolean> result = new ArrayList<Boolean>(this.orderByItems.size());
        for (OrderByItem eachOrderByItem : this.orderByItems) {
            result.add(this.getOrderValuesCaseSensitiveFromTables(schema, eachOrderByItem));
        }
        return result;
    }

    private boolean getOrderValuesCaseSensitiveFromTables(ShardingSphereSchema schema, OrderByItem eachOrderByItem) throws SQLException {
        for (SimpleTableSegment each : this.selectStatementContext.getTablesContext().getSimpleTables()) {
            String tableName = each.getTableName().getIdentifier().getValue();
            ShardingSphereTable table = schema.getTable(tableName);
            OrderByItemSegment orderByItemSegment = eachOrderByItem.getSegment();
            if (orderByItemSegment instanceof ColumnOrderByItemSegment) {
                String columnName = ((ColumnOrderByItemSegment)orderByItemSegment).getColumn().getIdentifier().getValue();
                if (!table.containsColumn(columnName)) continue;
                return table.getColumn(columnName).isCaseSensitive();
            }
            if (orderByItemSegment instanceof IndexOrderByItemSegment) {
                int columnIndex = ((IndexOrderByItemSegment)orderByItemSegment).getColumnIndex();
                String columnName = this.queryResult.getMetaData().getColumnName(columnIndex);
                if (!table.containsColumn(columnName)) continue;
                return table.getColumn(columnName).isCaseSensitive();
            }
            return false;
        }
        return false;
    }

    public boolean next() throws SQLException {
        boolean result = this.queryResult.next();
        this.orderValues = result ? this.getOrderValues() : Collections.emptyList();
        return result;
    }

    private List<Comparable<?>> getOrderValues() throws SQLException {
        ArrayList result = new ArrayList(this.orderByItems.size());
        for (OrderByItem each : this.orderByItems) {
            Object value = this.queryResult.getValue(each.getIndex(), Object.class);
            ShardingSpherePreconditions.checkState((null == value || value instanceof Comparable ? 1 : 0) != 0, () -> new NotImplementComparableValueException("Order by", value));
            result.add((Comparable)value);
        }
        return result;
    }

    @Override
    public int compareTo(OrderByValue orderByValue) {
        int i = 0;
        for (OrderByItem each : this.orderByItems) {
            int result = CompareUtils.compareTo(this.orderValues.get(i), orderByValue.orderValues.get(i), each.getSegment().getOrderDirection(), each.getSegment().getNullsOrderType(this.selectStatementContext.getDatabaseType()), this.orderValuesCaseSensitive.get(i));
            if (0 != result) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    @Generated
    public QueryResult getQueryResult() {
        return this.queryResult;
    }
}

