/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.storage;

import lombok.Generated;

public final class JobNodePath {
    private static final String LEADER_HOST_NODE = "leader/election/instance";
    private static final String CONFIG_NODE = "config";
    private static final String SERVERS_NODE = "servers";
    private static final String INSTANCES_NODE = "instances";
    private static final String SHARDING_NODE = "sharding";
    private final String jobName;

    public String getFullPath(String node) {
        return String.format("/%s/%s", this.jobName, node);
    }

    public String getConfigNodePath() {
        return String.format("/%s/%s", this.jobName, CONFIG_NODE);
    }

    public String getLeaderHostNodePath() {
        return String.format("/%s/%s", this.jobName, LEADER_HOST_NODE);
    }

    public String getServerNodePath() {
        return String.format("/%s/%s", this.jobName, SERVERS_NODE);
    }

    public String getServerNodePath(String serverIp) {
        return String.format("%s/%s", this.getServerNodePath(), serverIp);
    }

    public String getInstancesNodePath() {
        return String.format("/%s/%s", this.jobName, INSTANCES_NODE);
    }

    public String getInstanceNodePath(String instanceId) {
        return String.format("%s/%s", this.getInstancesNodePath(), instanceId);
    }

    public String getShardingNodePath() {
        return String.format("/%s/%s", this.jobName, SHARDING_NODE);
    }

    public String getShardingNodePath(String item, String nodeName) {
        return String.format("%s/%s/%s", this.getShardingNodePath(), item, nodeName);
    }

    @Generated
    public JobNodePath(String jobName) {
        this.jobName = jobName;
    }
}

