/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.frontend.mysql.command.query.binary;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class MySQLStatementIdGenerator {
    private static final MySQLStatementIdGenerator INSTANCE = new MySQLStatementIdGenerator();
    private final Map<Integer, AtomicInteger> connectionRegistry = new ConcurrentHashMap<Integer, AtomicInteger>();

    public static MySQLStatementIdGenerator getInstance() {
        return INSTANCE;
    }

    public void registerConnection(int connectionId) {
        this.connectionRegistry.put(connectionId, new AtomicInteger());
    }

    public int nextStatementId(int connectionId) {
        return this.connectionRegistry.get(connectionId).incrementAndGet();
    }

    public void unregisterConnection(int connectionId) {
        this.connectionRegistry.remove(connectionId);
    }
}

