/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.function.mysql.impl;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.util.BitString;
import org.apache.commons.lang3.StringUtils;

public final class MySQLBitCountFunction
extends SqlUserDefinedFunction {
    public MySQLBitCountFunction() {
        super(new SqlIdentifier("BIT_COUNT", SqlParserPos.ZERO), SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT_NULLABLE, InferTypes.BOOLEAN, OperandTypes.operandMetadata(Arrays.asList(SqlTypeFamily.NULL, SqlTypeFamily.ARRAY, SqlTypeFamily.STRING, SqlTypeFamily.NUMERIC), typeFactory -> ImmutableList.of((Object)typeFactory.createSqlType(SqlTypeName.BIGINT)), null, arg -> false), (Function)ScalarFunctionImpl.create(MySQLBitCountFunction.class, (String)"bitCount"));
    }

    public static Object bitCount(Object value) {
        if (null == value) {
            return null;
        }
        if (value instanceof byte[]) {
            return MySQLBitCountFunction.bitCount((byte[])value);
        }
        if (value instanceof String) {
            return StringUtils.isNumeric((CharSequence)((String)value)) ? Long.bitCount(Long.parseLong((String)value)) : 0;
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).bitCount();
        }
        if (value instanceof Integer) {
            return Integer.bitCount((Integer)value);
        }
        if (value instanceof Long) {
            return Long.bitCount((Long)value);
        }
        return 0;
    }

    private static long bitCount(byte[] byteValue) {
        long result = 0L;
        for (char each : BitString.createFromBytes((byte[])byteValue).toBitString().toCharArray()) {
            if ('1' != each) continue;
            ++result;
        }
        return result;
    }
}

