/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.distsql.handler.update;

import java.util.Collections;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.engine.update.rdl.rule.spi.database.DatabaseRuleDropExecutor;
import org.apache.shardingsphere.distsql.handler.required.DistSQLExecutorCurrentRuleRequired;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.algorithm.core.exception.UnregisteredAlgorithmException;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.exception.core.external.sql.identifier.SQLExceptionIdentifier;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.distsql.statement.DropDefaultShadowAlgorithmStatement;
import org.apache.shardingsphere.shadow.rule.ShadowRule;

@DistSQLExecutorCurrentRuleRequired(value=ShadowRule.class)
public final class DropDefaultShadowAlgorithmExecutor
implements DatabaseRuleDropExecutor<DropDefaultShadowAlgorithmStatement, ShadowRule, ShadowRuleConfiguration> {
    private ShardingSphereDatabase database;
    private ShadowRule rule;

    public void checkBeforeUpdate(DropDefaultShadowAlgorithmStatement sqlStatement) {
        if (!sqlStatement.isIfExists()) {
            this.checkAlgorithm();
        }
    }

    private void checkAlgorithm() {
        ShardingSpherePreconditions.checkNotNull((Object)this.rule.getConfiguration().getDefaultShadowAlgorithmName(), () -> new UnregisteredAlgorithmException("Shadow", "default", new SQLExceptionIdentifier(this.database.getName())));
    }

    public boolean hasAnyOneToBeDropped(DropDefaultShadowAlgorithmStatement sqlStatement) {
        return null != this.rule.getConfiguration().getDefaultShadowAlgorithmName();
    }

    public ShadowRuleConfiguration buildToBeDroppedRuleConfiguration(DropDefaultShadowAlgorithmStatement sqlStatement) {
        ShadowRuleConfiguration result = new ShadowRuleConfiguration();
        result.setShadowAlgorithms(Collections.singletonMap(this.rule.getConfiguration().getDefaultShadowAlgorithmName(), (AlgorithmConfiguration)this.rule.getConfiguration().getShadowAlgorithms().get(this.rule.getConfiguration().getDefaultShadowAlgorithmName())));
        result.setDefaultShadowAlgorithmName(this.rule.getConfiguration().getDefaultShadowAlgorithmName());
        return result;
    }

    public Class<ShadowRule> getRuleClass() {
        return ShadowRule.class;
    }

    public Class<DropDefaultShadowAlgorithmStatement> getType() {
        return DropDefaultShadowAlgorithmStatement.class;
    }

    @Generated
    public void setDatabase(ShardingSphereDatabase database) {
        this.database = database;
    }

    @Generated
    public void setRule(ShadowRule rule) {
        this.rule = rule;
    }
}

