/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.type.IntegerPrimaryKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.type.StringPrimaryKeyIngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.type.UnsupportedKeyIngestPosition;

public final class PrimaryKeyIngestPositionFactory {
    public static IngestPosition newInstance(String data) {
        List parts = Splitter.on((char)',').splitToList((CharSequence)data);
        Preconditions.checkArgument((3 == parts.size() ? 1 : 0) != 0, (Object)("Unknown primary key position: " + data));
        Preconditions.checkArgument((1 == ((String)parts.get(0)).length() ? 1 : 0) != 0, (Object)("Invalid primary key position type: " + (String)parts.get(0)));
        char type = ((String)parts.get(0)).charAt(0);
        String beginValue = (String)parts.get(1);
        String endValue = (String)parts.get(2);
        switch (type) {
            case 'i': {
                return new IntegerPrimaryKeyIngestPosition(Long.parseLong(beginValue), Long.parseLong(endValue));
            }
            case 's': {
                return new StringPrimaryKeyIngestPosition(beginValue, endValue);
            }
            case 'u': {
                return new UnsupportedKeyIngestPosition();
            }
        }
        throw new IllegalArgumentException("Unknown primary key position type: " + type);
    }

    public static IngestPosition newInstance(Object beginValue, Object endValue) {
        if (beginValue instanceof Number) {
            return new IntegerPrimaryKeyIngestPosition(((Number)beginValue).longValue(), null == endValue ? Long.MAX_VALUE : ((Number)endValue).longValue());
        }
        if (beginValue instanceof CharSequence) {
            return new StringPrimaryKeyIngestPosition(beginValue.toString(), null == endValue ? null : endValue.toString());
        }
        return new UnsupportedKeyIngestPosition();
    }

    @Generated
    private PrimaryKeyIngestPositionFactory() {
    }
}

