/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.core.advisor.executor;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.agent.api.advice.AgentAdvice;
import org.apache.shardingsphere.agent.core.advisor.config.AdvisorConfiguration;
import org.apache.shardingsphere.agent.core.advisor.config.MethodAdvisorConfiguration;
import org.apache.shardingsphere.agent.core.advisor.executor.AdviceExecutor;
import org.apache.shardingsphere.agent.core.advisor.executor.AdviceFactory;
import org.apache.shardingsphere.agent.core.advisor.executor.type.ConstructorAdviceExecutor;
import org.apache.shardingsphere.agent.core.advisor.executor.type.InstanceMethodAdviceExecutor;
import org.apache.shardingsphere.agent.core.advisor.executor.type.StaticMethodAdviceExecutor;
import org.apache.shardingsphere.agent.core.plugin.classloader.ClassLoaderContext;
import org.apache.shardingsphere.shade.net.bytebuddy.description.method.MethodDescription;

public final class AdviceExecutorFactory {
    private final AdviceFactory adviceFactory;
    private final AdvisorConfiguration advisorConfig;

    public AdviceExecutorFactory(ClassLoaderContext classLoaderContext, AdvisorConfiguration advisorConfig) {
        this.adviceFactory = new AdviceFactory(classLoaderContext);
        this.advisorConfig = advisorConfig;
    }

    public Optional<AdviceExecutor> findMatchedAdviceExecutor(MethodDescription.InDefinedShape methodDescription) {
        HashMap<String, Collection<AgentAdvice>> advices = new HashMap<String, Collection<AgentAdvice>>(this.advisorConfig.getAdvisors().size(), 1.0f);
        for (MethodAdvisorConfiguration each : this.advisorConfig.getAdvisors()) {
            if (!each.getPointcut().matches(methodDescription)) continue;
            advices.computeIfAbsent(each.getPluginType(), key -> new LinkedList());
            ((Collection)advices.get(each.getPluginType())).add(this.adviceFactory.getAdvice(each.getAdviceClassName()));
        }
        if (advices.isEmpty()) {
            return Optional.empty();
        }
        if (this.isConstructor(methodDescription)) {
            return Optional.of(new ConstructorAdviceExecutor(this.convert(advices)));
        }
        if (this.isStaticMethod(methodDescription)) {
            return Optional.of(new StaticMethodAdviceExecutor(this.convert(advices)));
        }
        if (this.isMethod(methodDescription)) {
            return Optional.of(new InstanceMethodAdviceExecutor(this.convert(advices)));
        }
        return Optional.empty();
    }

    private boolean isConstructor(MethodDescription.InDefinedShape methodDescription) {
        return methodDescription.isConstructor();
    }

    private boolean isStaticMethod(MethodDescription.InDefinedShape methodDescription) {
        return methodDescription.isStatic() && this.isMethod(methodDescription);
    }

    private boolean isMethod(MethodDescription.InDefinedShape methodDescription) {
        return !methodDescription.isAbstract() && !methodDescription.isSynthetic();
    }

    private <T extends AgentAdvice> Map<String, Collection<T>> convert(Map<String, Collection<AgentAdvice>> advices) {
        HashMap<String, Collection<T>> result = new HashMap<String, Collection<T>>(advices.size(), 1.0f);
        for (Map.Entry<String, Collection<AgentAdvice>> entry : advices.entrySet()) {
            result.put(entry.getKey(), new LinkedList());
            for (AgentAdvice each : entry.getValue()) {
                ((Collection)result.get(entry.getKey())).add(each);
            }
        }
        return result;
    }
}

