/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.auth;

import java.lang.reflect.Field;
import java.util.Map;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.grpc.GrpcExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.http.HttpExporterBuilder;

public interface Authenticator {
    public Map<String, String> getHeaders();

    public static void setAuthenticatorOnDelegate(Object builder, Authenticator authenticator) {
        try {
            Field field = builder.getClass().getDeclaredField("delegate");
            field.setAccessible(true);
            Object value = field.get(builder);
            if (value instanceof GrpcExporterBuilder) {
                throw new IllegalArgumentException("GrpcExporterBuilder not supported yet.");
            }
            if (!(value instanceof HttpExporterBuilder)) {
                throw new IllegalArgumentException("Delegate field is not type DefaultGrpcExporterBuilder or OkHttpGrpcExporterBuilder.");
            }
            ((HttpExporterBuilder)value).setAuthenticator(authenticator);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Unable to access delegate reflectively.", e);
        }
    }
}

