/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.view;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributeKey;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.AttributesBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;

final class AdviceAttributesProcessor
extends AttributesProcessor {
    private final Set<AttributeKey<?>> attributeKeys;

    AdviceAttributesProcessor(List<AttributeKey<?>> adviceAttributeKeys) {
        this.attributeKeys = new HashSet(adviceAttributeKeys);
    }

    @Override
    public Attributes process(Attributes incoming, Context context) {
        if (!this.hasExtraKeys(incoming)) {
            return incoming;
        }
        AttributesBuilder builder = incoming.toBuilder();
        builder.removeIf(key -> !this.attributeKeys.contains(key));
        return builder.build();
    }

    private boolean hasExtraKeys(Attributes attributes) {
        boolean[] result = new boolean[]{false};
        attributes.forEach((key, value) -> {
            if (!result[0] && !this.attributeKeys.contains(key)) {
                result[0] = true;
            }
        });
        return result[0];
    }

    @Override
    public boolean usesContext() {
        return false;
    }

    public String toString() {
        return "AdviceAttributesProcessor{attributeKeys=" + this.attributeKeys + '}';
    }
}

