/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.cache;

import lombok.Generated;
import org.apache.shardingsphere.sharding.api.config.cache.ShardingCacheConfiguration;
import org.apache.shardingsphere.sharding.cache.checker.ShardingRouteCacheableChecker;
import org.apache.shardingsphere.sharding.cache.route.cache.ShardingRouteCache;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.timeservice.core.rule.TimestampServiceRule;
import org.apache.shardingsphere.timeservice.core.rule.builder.DefaultTimestampServiceConfigurationBuilder;

public final class ShardingCache {
    private final ShardingCacheConfiguration configuration;
    private final ShardingRule shardingRule;
    private final TimestampServiceRule timestampServiceRule;
    private final ShardingRouteCacheableChecker routeCacheableChecker;
    private final ShardingRouteCache routeCache;

    public ShardingCache(ShardingCacheConfiguration config, ShardingRule shardingRule) {
        this.configuration = config;
        this.shardingRule = shardingRule;
        this.timestampServiceRule = new TimestampServiceRule(new DefaultTimestampServiceConfigurationBuilder().build());
        this.routeCacheableChecker = new ShardingRouteCacheableChecker(this);
        this.routeCache = new ShardingRouteCache(config.getRouteCache());
    }

    @Generated
    public ShardingCacheConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    @Generated
    public TimestampServiceRule getTimestampServiceRule() {
        return this.timestampServiceRule;
    }

    @Generated
    public ShardingRouteCacheableChecker getRouteCacheableChecker() {
        return this.routeCacheableChecker;
    }

    @Generated
    public ShardingRouteCache getRouteCache() {
        return this.routeCache;
    }
}

