/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.merge.dql.pagination;

import java.sql.SQLException;
import org.apache.shardingsphere.infra.binder.context.segment.select.pagination.PaginationContext;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.decorator.DecoratorMergedResult;

public final class TopAndRowNumberDecoratorMergedResult
extends DecoratorMergedResult {
    private final PaginationContext paginationContext;
    private final boolean skipAll;
    private long rowNumber;

    public TopAndRowNumberDecoratorMergedResult(MergedResult mergedResult, PaginationContext paginationContext) throws SQLException {
        super(mergedResult);
        this.paginationContext = paginationContext;
        this.skipAll = this.skipOffset();
    }

    private boolean skipOffset() throws SQLException {
        long end = this.paginationContext.getActualOffset();
        for (long count = 0L; count < end; ++count) {
            if (this.getMergedResult().next()) continue;
            return true;
        }
        this.rowNumber = end + 1L;
        return false;
    }

    public boolean next() throws SQLException {
        if (this.skipAll) {
            return false;
        }
        if (!this.paginationContext.getActualRowCount().isPresent()) {
            return this.getMergedResult().next();
        }
        return this.rowNumber++ <= (Long)this.paginationContext.getActualRowCount().get() && this.getMergedResult().next();
    }
}

