/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule;

import com.cedarsoftware.util.CaseInsensitiveMap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sharding.exception.metadata.ActualTableNotFoundException;
import org.apache.shardingsphere.sharding.exception.metadata.BindingTableNotFoundException;
import org.apache.shardingsphere.sharding.rule.ShardingTable;

public final class BindingTableRule {
    private final Map<String, ShardingTable> shardingTables = new CaseInsensitiveMap();

    public boolean hasLogicTable(String logicTable) {
        return this.shardingTables.containsKey(logicTable);
    }

    public String getBindingActualTable(String dataSource, String logicTable, String otherLogicTable, String otherActualTable) {
        Optional<ShardingTable> otherShardingTable = Optional.ofNullable(this.shardingTables.get(otherLogicTable));
        int index = otherShardingTable.map(optional -> optional.findActualTableIndex(dataSource, otherActualTable)).orElse(-1);
        if (-1 == index) {
            throw new ActualTableNotFoundException(dataSource, otherActualTable);
        }
        Optional<ShardingTable> shardingTable = Optional.ofNullable(this.shardingTables.get(logicTable));
        if (shardingTable.isPresent()) {
            return shardingTable.get().getActualDataNodes().get(index).getTableName();
        }
        throw new BindingTableNotFoundException(dataSource, logicTable, otherActualTable);
    }

    public Collection<String> getAllLogicTables() {
        return this.shardingTables.keySet();
    }

    public Map<String, String> getLogicAndActualTables(String dataSource, String logicTable, String actualTable, Collection<String> availableLogicBindingTables) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(availableLogicBindingTables.size(), 1.0f);
        for (String each : availableLogicBindingTables) {
            if (each.equalsIgnoreCase(logicTable) || !this.hasLogicTable(each)) continue;
            result.put(each, this.getBindingActualTable(dataSource, each, logicTable, actualTable));
        }
        return result;
    }

    @Generated
    public BindingTableRule() {
    }

    @Generated
    public Map<String, ShardingTable> getShardingTables() {
        return this.shardingTables;
    }
}

