/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector.jdbc.connection;

import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ConnectionResourceLock {
    private static final long DEFAULT_TIMEOUT_MILLISECONDS = 200L;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    public void doAwait(ChannelHandlerContext context) {
        while (!context.channel().isWritable() && context.channel().isActive()) {
            context.flush();
            this.lock.lock();
            try {
                this.condition.await(200L, TimeUnit.MILLISECONDS);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void doNotify() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

