/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.distsql.ral.queryable;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.distsql.handler.aware.DistSQLExecutorConnectionContextAware;
import org.apache.shardingsphere.distsql.handler.engine.DistSQLConnectionContext;
import org.apache.shardingsphere.distsql.handler.engine.query.DistSQLQueryExecutor;
import org.apache.shardingsphere.distsql.statement.ral.queryable.show.ShowDistVariablesStatement;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.infra.config.props.temporary.TemporaryConfigurationPropertyKey;
import org.apache.shardingsphere.infra.merge.result.impl.local.LocalDataQueryResultRow;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPI;
import org.apache.shardingsphere.infra.util.regex.RegexUtils;
import org.apache.shardingsphere.logging.logger.ShardingSphereLogger;
import org.apache.shardingsphere.logging.rule.LoggingRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.handler.distsql.ral.common.DistSQLVariable;

public final class ShowDistVariablesExecutor
implements DistSQLQueryExecutor<ShowDistVariablesStatement>,
DistSQLExecutorConnectionContextAware {
    private DistSQLConnectionContext connectionContext;

    public Collection<String> getColumnNames(ShowDistVariablesStatement sqlStatement) {
        return Arrays.asList("variable_name", "variable_value");
    }

    public Collection<LocalDataQueryResultRow> getRows(ShowDistVariablesStatement sqlStatement, ContextManager contextManager) {
        ShardingSphereMetaData metaData = contextManager.getMetaDataContexts().getMetaData();
        Collection result = ConfigurationPropertyKey.getKeyNames().stream().filter(each -> !ConfigurationPropertyKey.SQL_SHOW.name().equals(each) && !ConfigurationPropertyKey.SQL_SIMPLE.name().equals(each)).map(each -> new LocalDataQueryResultRow(new Object[]{each.toLowerCase(), this.getStringResult(metaData.getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)each)))})).collect(Collectors.toList());
        result.addAll(TemporaryConfigurationPropertyKey.getKeyNames().stream().map(each -> new LocalDataQueryResultRow(new Object[]{each.toLowerCase(), this.getStringResult(metaData.getTemporaryProps().getValue((Enum)TemporaryConfigurationPropertyKey.valueOf((String)each)))})).collect(Collectors.toList()));
        result.add(new LocalDataQueryResultRow(new Object[]{DistSQLVariable.CACHED_CONNECTIONS.name().toLowerCase(), this.connectionContext.getConnectionSize()}));
        this.addLoggingPropsRows(metaData, result);
        if (sqlStatement.getLikePattern().isPresent()) {
            String pattern = RegexUtils.convertLikePatternToRegex((String)((String)sqlStatement.getLikePattern().get()));
            result = result.stream().filter(each -> Pattern.compile(pattern, 2).matcher((String)each.getCell(1)).matches()).collect(Collectors.toList());
        }
        return result.stream().sorted(Comparator.comparing(each -> each.getCell(1).toString())).collect(Collectors.toList());
    }

    private String getStringResult(Object value) {
        if (null == value) {
            return "";
        }
        return value instanceof TypedSPI ? ((TypedSPI)value).getType().toString() : value.toString();
    }

    private void addLoggingPropsRows(ShardingSphereMetaData metaData, Collection<LocalDataQueryResultRow> rows) {
        Optional sqlLogger = metaData.getGlobalRuleMetaData().findSingleRule(LoggingRule.class).flatMap(LoggingRule::getSQLLogger);
        if (sqlLogger.isPresent()) {
            Properties sqlLoggerProps = ((ShardingSphereLogger)sqlLogger.get()).getProps();
            rows.add(new LocalDataQueryResultRow(new Object[]{"sql_show", sqlLoggerProps.getOrDefault((Object)"enable", Boolean.FALSE).toString()}));
            rows.add(new LocalDataQueryResultRow(new Object[]{"sql_simple", sqlLoggerProps.getOrDefault((Object)"simple", Boolean.FALSE).toString()}));
        } else {
            rows.add(new LocalDataQueryResultRow(new Object[]{"sql_show", metaData.getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)"sql_show".toUpperCase())).toString()}));
            rows.add(new LocalDataQueryResultRow(new Object[]{"sql_simple", metaData.getProps().getValue((Enum)ConfigurationPropertyKey.valueOf((String)"sql_simple".toUpperCase())).toString()}));
        }
    }

    public Class<ShowDistVariablesStatement> getType() {
        return ShowDistVariablesStatement.class;
    }

    @Generated
    public void setConnectionContext(DistSQLConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }
}

