/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.generic;

import java.util.List;
import java.util.StringJoiner;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.QuoteCharacter;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.Attachable;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.pojo.SQLToken;

public final class InsertColumnsToken
extends SQLToken
implements Attachable {
    private final List<String> columns;
    private final QuoteCharacter quoteCharacter;

    public InsertColumnsToken(int startIndex, List<String> columns) {
        super(startIndex);
        this.columns = columns;
        this.quoteCharacter = QuoteCharacter.NONE;
    }

    public InsertColumnsToken(int startIndex, List<String> columns, QuoteCharacter quoteCharacter) {
        super(startIndex);
        this.columns = columns;
        this.quoteCharacter = quoteCharacter;
    }

    public String toString() {
        if (this.columns.isEmpty()) {
            return "";
        }
        StringJoiner result = new StringJoiner(", ", ", ", "");
        this.columns.forEach(each -> result.add(this.quoteCharacter.wrap(each)));
        return result.toString();
    }

    @Override
    public int getStopIndex() {
        return this.getStartIndex();
    }
}

