/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantCP;
import org.aspectj.apache.bcel.classfile.ConstantClass;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFieldref;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.aspectj.apache.bcel.classfile.ConstantInvokeDynamic;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantMethodHandle;
import org.aspectj.apache.bcel.classfile.ConstantMethodType;
import org.aspectj.apache.bcel.classfile.ConstantMethodref;
import org.aspectj.apache.bcel.classfile.ConstantNameAndType;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Node;
import org.aspectj.apache.bcel.classfile.SimpleConstant;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.ObjectType;

public class ConstantPool
implements Node {
    private Constant[] pool;
    private int poolSize;
    private Map<String, Integer> utf8Cache = new HashMap<String, Integer>();
    private Map<String, Integer> methodCache = new HashMap<String, Integer>();
    private Map<String, Integer> fieldCache = new HashMap<String, Integer>();

    public int getSize() {
        return this.poolSize;
    }

    public ConstantPool() {
        this.pool = new Constant[10];
        this.poolSize = 0;
    }

    public ConstantPool(Constant[] constantArray) {
        this.pool = constantArray;
        this.poolSize = constantArray == null ? 0 : constantArray.length;
    }

    ConstantPool(DataInputStream dataInputStream) throws IOException {
        this.poolSize = dataInputStream.readUnsignedShort();
        this.pool = new Constant[this.poolSize];
        for (int i = 1; i < this.poolSize; ++i) {
            this.pool[i] = Constant.readConstant(dataInputStream);
            byte by = this.pool[i].getTag();
            if (by != 6 && by != 5) continue;
            ++i;
        }
    }

    public Constant getConstant(int n, byte by) {
        Constant constant = this.getConstant(n);
        if (constant.tag == by) {
            return constant;
        }
        throw new ClassFormatException("Expected class '" + Constants.CONSTANT_NAMES[by] + "' at index " + n + " and found " + constant);
    }

    public Constant getConstant(int n) {
        try {
            return this.pool[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ClassFormatException("Index " + n + " into constant pool (size:" + this.poolSize + ") is invalid");
        }
    }

    public ConstantPool copy() {
        Constant[] constantArray = new Constant[this.poolSize];
        for (int i = 1; i < this.poolSize; ++i) {
            if (this.pool[i] == null) continue;
            constantArray[i] = this.pool[i].copy();
        }
        return new ConstantPool(constantArray);
    }

    public String getConstantString(int n, byte by) throws ClassFormatException {
        int n2;
        Constant constant = this.getConstant(n, by);
        switch (by) {
            case 7: {
                n2 = ((ConstantClass)constant).getNameIndex();
                break;
            }
            case 8: {
                n2 = ((ConstantString)constant).getStringIndex();
                break;
            }
            default: {
                throw new RuntimeException("getConstantString called with illegal tag " + by);
            }
        }
        constant = this.getConstant(n2, (byte)1);
        return ((ConstantUtf8)constant).getValue();
    }

    public String constantToString(Constant constant) {
        String string;
        switch (constant.tag) {
            case 7: {
                int n = ((ConstantClass)constant).getNameIndex();
                constant = this.getConstant(n, (byte)1);
                string = Utility.compactClassName(((ConstantUtf8)constant).getValue(), false);
                break;
            }
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = this.getConstant(n, (byte)1);
                string = "\"" + ConstantPool.escape(((ConstantUtf8)constant).getValue()) + "\"";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = ((SimpleConstant)((Object)constant)).getStringValue();
                break;
            }
            case 12: {
                string = this.constantToString(((ConstantNameAndType)constant).getNameIndex(), (byte)1) + " " + this.constantToString(((ConstantNameAndType)constant).getSignatureIndex(), (byte)1);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                string = this.constantToString(((ConstantCP)constant).getClassIndex(), (byte)7) + "." + this.constantToString(((ConstantCP)constant).getNameAndTypeIndex(), (byte)12);
                break;
            }
            case 18: {
                ConstantInvokeDynamic constantInvokeDynamic = (ConstantInvokeDynamic)constant;
                string = constantInvokeDynamic.toString();
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant type " + constant.tag);
            }
        }
        return string;
    }

    private static final String escape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 5);
        char[] cArray = string.toCharArray();
        block7: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block7;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public String constantToString(int n, byte by) {
        Constant constant = this.getConstant(n, by);
        return this.constantToString(constant);
    }

    public String constantToString(int n) {
        return this.constantToString(this.getConstant(n));
    }

    @Override
    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitConstantPool(this);
    }

    public Constant[] getConstantPool() {
        return this.pool;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.poolSize);
        for (int i = 1; i < this.poolSize; ++i) {
            if (this.pool[i] == null) continue;
            this.pool[i].dump(dataOutputStream);
        }
    }

    public ConstantUtf8 getConstantUtf8(int n) {
        Constant constant = this.getConstant(n);
        assert (constant != null);
        assert (constant.tag == 1);
        return (ConstantUtf8)constant;
    }

    public String getConstantString_CONSTANTClass(int n) {
        ConstantClass constantClass = (ConstantClass)this.getConstant(n, (byte)7);
        n = constantClass.getNameIndex();
        return ((ConstantUtf8)this.getConstant(n, (byte)1)).getValue();
    }

    public int getLength() {
        return this.poolSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < this.poolSize; ++i) {
            stringBuffer.append(i + ")" + this.pool[i] + "\n");
        }
        return stringBuffer.toString();
    }

    public int lookupInteger(int n) {
        for (int i = 1; i < this.poolSize; ++i) {
            ConstantInteger constantInteger;
            if (!(this.pool[i] instanceof ConstantInteger) || (constantInteger = (ConstantInteger)this.pool[i]).getValue() != n) continue;
            return i;
        }
        return -1;
    }

    public int lookupUtf8(String string) {
        Integer n = this.utf8Cache.get(string);
        if (n != null) {
            return n;
        }
        for (int i = 1; i < this.poolSize; ++i) {
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 1 || !((ConstantUtf8)constant).getValue().equals(string)) continue;
            this.utf8Cache.put(string, i);
            return i;
        }
        return -1;
    }

    public int lookupClass(String string) {
        for (int i = 1; i < this.poolSize; ++i) {
            int n;
            String string2;
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 7 || !(string2 = ((ConstantUtf8)this.pool[n = ((ConstantClass)constant).getNameIndex()]).getValue()).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int addUtf8(String string) {
        int n = this.lookupUtf8(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.poolSize;
        this.pool[this.poolSize++] = new ConstantUtf8(string);
        return n;
    }

    public int addInteger(int n) {
        int n2 = this.lookupInteger(n);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        n2 = this.poolSize;
        this.pool[this.poolSize++] = new ConstantInteger(n);
        return n2;
    }

    public int addArrayClass(ArrayType arrayType) {
        return this.addClass(arrayType.getSignature());
    }

    public int addClass(ObjectType objectType) {
        return this.addClass(objectType.getClassName());
    }

    public int addClass(String string) {
        String string2 = string.replace('.', '/');
        int n = this.lookupClass(string2);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        ConstantClass constantClass = new ConstantClass(this.addUtf8(string2));
        n = this.poolSize;
        this.pool[this.poolSize++] = constantClass;
        return n;
    }

    private void adjustSize() {
        if (this.poolSize + 3 >= this.pool.length) {
            Constant[] constantArray = this.pool;
            this.pool = new Constant[constantArray.length + 8];
            System.arraycopy(constantArray, 0, this.pool, 0, constantArray.length);
        }
        if (this.poolSize == 0) {
            this.poolSize = 1;
        }
    }

    public int addFieldref(String string, String string2, String string3) {
        int n = this.lookupFieldref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        n = this.poolSize;
        this.pool[this.poolSize++] = new ConstantFieldref(n2, n3);
        return n;
    }

    public int lookupFieldref(String string, String string2, String string3) {
        String string4 = new StringBuffer().append(string = string.replace('.', '/')).append(string2).append(string3).toString();
        Integer n = this.fieldCache.get(string4);
        if (n != null) {
            return n;
        }
        for (int i = 1; i < this.poolSize; ++i) {
            String string5;
            String string6;
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 9) continue;
            ConstantFieldref constantFieldref = (ConstantFieldref)constant;
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.pool[constantFieldref.getNameAndTypeIndex()];
            int n2 = constantFieldref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.pool[n2];
            String string7 = ((ConstantUtf8)this.pool[constantClass.getNameIndex()]).getValue();
            if (!string7.equals(string) || !(string6 = ((ConstantUtf8)this.pool[constantNameAndType.getNameIndex()]).getValue()).equals(string2) || !(string5 = ((ConstantUtf8)this.pool[constantNameAndType.getSignatureIndex()]).getValue()).equals(string3)) continue;
            this.fieldCache.put(string4, new Integer(i));
            return i;
        }
        return -1;
    }

    public int addNameAndType(String string, String string2) {
        int n = this.lookupNameAndType(string, string2);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addUtf8(string);
        int n3 = this.addUtf8(string2);
        n = this.poolSize;
        this.pool[this.poolSize++] = new ConstantNameAndType(n2, n3);
        return n;
    }

    public int lookupNameAndType(String string, String string2) {
        for (int i = 1; i < this.poolSize; ++i) {
            String string3;
            ConstantNameAndType constantNameAndType;
            String string4;
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 12 || !(string4 = ((ConstantUtf8)this.pool[(constantNameAndType = (ConstantNameAndType)constant).getNameIndex()]).getValue()).equals(string) || !(string3 = ((ConstantUtf8)this.pool[constantNameAndType.getSignatureIndex()]).getValue()).equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public int addFloat(float f) {
        int n = this.lookupFloat(f);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.poolSize;
        this.pool[this.poolSize++] = new ConstantFloat(f);
        return n;
    }

    public int lookupFloat(float f) {
        int n = Float.floatToIntBits(f);
        for (int i = 1; i < this.poolSize; ++i) {
            ConstantFloat constantFloat;
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 4 || Float.floatToIntBits((constantFloat = (ConstantFloat)constant).getValue().floatValue()) != n) continue;
            return i;
        }
        return -1;
    }

    public int addDouble(double d) {
        int n = this.lookupDouble(d);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.poolSize;
        this.pool[this.poolSize] = new ConstantDouble(d);
        this.poolSize += 2;
        return n;
    }

    public int lookupDouble(double d) {
        long l = Double.doubleToLongBits(d);
        for (int i = 1; i < this.poolSize; ++i) {
            ConstantDouble constantDouble;
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 6 || Double.doubleToLongBits((constantDouble = (ConstantDouble)constant).getValue()) != l) continue;
            return i;
        }
        return -1;
    }

    public int addLong(long l) {
        int n = this.lookupLong(l);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.poolSize;
        this.pool[this.poolSize] = new ConstantLong(l);
        this.poolSize += 2;
        return n;
    }

    public int lookupString(String string) {
        for (int i = 1; i < this.poolSize; ++i) {
            ConstantString constantString;
            ConstantUtf8 constantUtf8;
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 8 || !(constantUtf8 = (ConstantUtf8)this.pool[(constantString = (ConstantString)constant).getStringIndex()]).getValue().equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int addString(String string) {
        int n = this.lookupString(string);
        if (n != -1) {
            return n;
        }
        int n2 = this.addUtf8(string);
        this.adjustSize();
        ConstantString constantString = new ConstantString(n2);
        n = this.poolSize;
        this.pool[this.poolSize++] = constantString;
        return n;
    }

    public int lookupLong(long l) {
        for (int i = 1; i < this.poolSize; ++i) {
            ConstantLong constantLong;
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 5 || (constantLong = (ConstantLong)constant).getValue() != l) continue;
            return i;
        }
        return -1;
    }

    public int addConstant(Constant constant, ConstantPool constantPool) {
        Constant[] constantArray = constantPool.getConstantPool();
        switch (constant.getTag()) {
            case 8: {
                ConstantString constantString = (ConstantString)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantString.getStringIndex()];
                return this.addString(constantUtf8.getValue());
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                return this.addClass(constantUtf8.getValue());
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                ConstantUtf8 constantUtf82 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                return this.addNameAndType(constantUtf8.getValue(), constantUtf82.getValue());
            }
            case 18: {
                ConstantInvokeDynamic constantInvokeDynamic = (ConstantInvokeDynamic)constant;
                int n = constantInvokeDynamic.getBootstrapMethodAttrIndex();
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantArray[constantInvokeDynamic.getNameAndTypeIndex()];
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                ConstantUtf8 constantUtf83 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                int n2 = this.addNameAndType(constantUtf8.getValue(), constantUtf83.getValue());
                return this.addInvokeDynamic(n, n2);
            }
            case 15: {
                ConstantMethodHandle constantMethodHandle = (ConstantMethodHandle)constant;
                return this.addMethodHandle(constantMethodHandle.getReferenceKind(), this.addConstant(constantArray[constantMethodHandle.getReferenceIndex()], constantPool));
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)constant).getValue());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)constant).getValue());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)constant).getValue().floatValue());
            }
            case 5: {
                return this.addLong(((ConstantLong)constant).getValue());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)constant).getValue());
            }
            case 16: {
                ConstantMethodType constantMethodType = (ConstantMethodType)constant;
                return this.addMethodType(this.addConstant(constantArray[constantMethodType.getDescriptorIndex()], constantPool));
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP constantCP = (ConstantCP)constant;
                ConstantClass constantClass = (ConstantClass)constantArray[constantCP.getClassIndex()];
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantArray[constantCP.getNameAndTypeIndex()];
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                String string = constantUtf8.getValue().replace('/', '.');
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                String string2 = constantUtf8.getValue();
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                String string3 = constantUtf8.getValue();
                switch (constant.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(string, string2, string3);
                    }
                    case 10: {
                        return this.addMethodref(string, string2, string3);
                    }
                    case 9: {
                        return this.addFieldref(string, string2, string3);
                    }
                }
                throw new RuntimeException("Unknown constant type " + constant);
            }
        }
        throw new RuntimeException("Unknown constant type " + constant);
    }

    public int addMethodHandle(byte by, int n) {
        this.adjustSize();
        int n2 = this.poolSize;
        this.pool[this.poolSize++] = new ConstantMethodHandle(by, n);
        return n2;
    }

    public int addMethodType(int n) {
        this.adjustSize();
        int n2 = this.poolSize;
        this.pool[this.poolSize++] = new ConstantMethodType(n);
        return n2;
    }

    public int addMethodref(String string, String string2, String string3) {
        int n = this.lookupMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addNameAndType(string2, string3);
        int n3 = this.addClass(string);
        n = this.poolSize;
        this.pool[this.poolSize++] = new ConstantMethodref(n3, n2);
        return n;
    }

    public int addInvokeDynamic(int n, int n2) {
        this.adjustSize();
        int n3 = this.poolSize;
        this.pool[this.poolSize++] = new ConstantInvokeDynamic(n, n2);
        return n3;
    }

    public int addInterfaceMethodref(String string, String string2, String string3) {
        int n = this.lookupInterfaceMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        n = this.poolSize;
        this.pool[this.poolSize++] = new ConstantInterfaceMethodref(n2, n3);
        return n;
    }

    public int lookupInterfaceMethodref(String string, String string2, String string3) {
        string = string.replace('.', '/');
        for (int i = 1; i < this.poolSize; ++i) {
            String string4;
            ConstantNameAndType constantNameAndType;
            String string5;
            ConstantInterfaceMethodref constantInterfaceMethodref;
            ConstantClass constantClass;
            String string6;
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 11 || !(string6 = ((ConstantUtf8)this.pool[(constantClass = (ConstantClass)this.pool[(constantInterfaceMethodref = (ConstantInterfaceMethodref)constant).getClassIndex()]).getNameIndex()]).getValue()).equals(string) || !(string5 = ((ConstantUtf8)this.pool[(constantNameAndType = (ConstantNameAndType)this.pool[constantInterfaceMethodref.getNameAndTypeIndex()]).getNameIndex()]).getValue()).equals(string2) || !(string4 = ((ConstantUtf8)this.pool[constantNameAndType.getSignatureIndex()]).getValue()).equals(string3)) continue;
            return i;
        }
        return -1;
    }

    public int lookupMethodref(String string, String string2, String string3) {
        String string4 = new StringBuffer().append(string).append(string2).append(string3).toString();
        Integer n = this.methodCache.get(string4);
        if (n != null) {
            return n;
        }
        string = string.replace('.', '/');
        for (int i = 1; i < this.poolSize; ++i) {
            String string5;
            String string6;
            Constant constant = this.pool[i];
            if (constant == null || constant.tag != 10) continue;
            ConstantMethodref constantMethodref = (ConstantMethodref)constant;
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)this.pool[constantMethodref.getNameAndTypeIndex()];
            int n2 = constantMethodref.getClassIndex();
            ConstantClass constantClass = (ConstantClass)this.pool[n2];
            String string7 = ((ConstantUtf8)this.pool[constantClass.getNameIndex()]).getValue();
            if (!string7.equals(string) || !(string6 = ((ConstantUtf8)this.pool[constantNameAndType.getNameIndex()]).getValue()).equals(string2) || !(string5 = ((ConstantUtf8)this.pool[constantNameAndType.getSignatureIndex()]).getValue()).equals(string3)) continue;
            this.methodCache.put(string4, new Integer(i));
            return i;
        }
        return -1;
    }

    public ConstantPool getFinalConstantPool() {
        Constant[] constantArray = new Constant[this.poolSize];
        System.arraycopy(this.pool, 0, constantArray, 0, this.poolSize);
        return new ConstantPool(constantArray);
    }
}

