/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.classfile.annotation.NameValuePair;

public class AnnotationElementValue
extends ElementValue {
    private AnnotationGen a;

    public AnnotationElementValue(AnnotationGen annotationGen, ConstantPool constantPool) {
        super(64, constantPool);
        this.a = annotationGen;
    }

    public AnnotationElementValue(int n, AnnotationGen annotationGen, ConstantPool constantPool) {
        super(n, constantPool);
        assert (n == 64);
        this.a = annotationGen;
    }

    public AnnotationElementValue(AnnotationElementValue annotationElementValue, ConstantPool constantPool, boolean bl) {
        super(64, constantPool);
        this.a = new AnnotationGen(annotationElementValue.getAnnotation(), constantPool, bl);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        this.a.dump(dataOutputStream);
    }

    @Override
    public String stringifyValue() {
        StringBuffer stringBuffer = new StringBuffer();
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.cpool.getConstant(this.a.getTypeIndex(), (byte)1);
        stringBuffer.append(constantUtf8.getValue());
        List<NameValuePair> list = this.a.getValues();
        if (list != null && list.size() > 0) {
            stringBuffer.append("(");
            for (int i = 0; i < list.size(); ++i) {
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(list.get(i).getNameString()).append("=").append(list.get(i).getValue().stringifyValue());
            }
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public AnnotationGen getAnnotation() {
        return this.a;
    }
}

