/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.generic.BasicType;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.ReferenceType;
import org.aspectj.apache.bcel.generic.Type;

public final class ArrayType
extends ReferenceType {
    private int dimensions;
    private Type basic_type;

    public ArrayType(byte by, int n) {
        this(BasicType.getType(by), n);
    }

    public ArrayType(String string, int n) {
        this(new ObjectType(string), n);
    }

    public ArrayType(Type type, int n) {
        super((byte)13, "<dummy>");
        Object object;
        if (n < 1 || n > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + n);
        }
        switch (type.getType()) {
            case 13: {
                object = (ArrayType)type;
                this.dimensions = n + ((ArrayType)object).dimensions;
                this.basic_type = ((ArrayType)object).basic_type;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = n;
                this.basic_type = type;
            }
        }
        object = new StringBuffer();
        for (int i = 0; i < this.dimensions; ++i) {
            ((StringBuffer)object).append('[');
        }
        ((StringBuffer)object).append(this.basic_type.getSignature());
        this.signature = ((StringBuffer)object).toString();
    }

    public Type getBasicType() {
        return this.basic_type;
    }

    public Type getElementType() {
        if (this.dimensions == 1) {
            return this.basic_type;
        }
        return new ArrayType(this.basic_type, this.dimensions - 1);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int hashCode() {
        return this.basic_type.hashCode() ^ this.dimensions;
    }

    public boolean equals(Object object) {
        if (object instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object;
            return arrayType.dimensions == this.dimensions && arrayType.basic_type.equals(this.basic_type);
        }
        return false;
    }
}

