/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.Constants;
import org.aspectj.apache.bcel.classfile.Constant;
import org.aspectj.apache.bcel.classfile.ConstantClass;
import org.aspectj.apache.bcel.classfile.ConstantDouble;
import org.aspectj.apache.bcel.classfile.ConstantFloat;
import org.aspectj.apache.bcel.classfile.ConstantInteger;
import org.aspectj.apache.bcel.classfile.ConstantLong;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantString;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.Type;

public class InstructionCP
extends Instruction {
    protected int index;

    public InstructionCP(short s, int n) {
        super(s);
        this.index = n;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.opcode == 19 && this.index < 256) {
            dataOutputStream.writeByte(18);
            dataOutputStream.writeByte(this.index);
        } else {
            dataOutputStream.writeByte(this.opcode);
            if (Constants.iLen[this.opcode] == 2) {
                if (this.index > 255) {
                    throw new IllegalStateException();
                }
                dataOutputStream.writeByte(this.index);
            } else {
                dataOutputStream.writeShort(this.index);
            }
        }
    }

    @Override
    public int getLength() {
        if (this.opcode == 19 && this.index < 256) {
            return 2;
        }
        return super.getLength();
    }

    @Override
    public String toString(boolean bl) {
        return super.toString(bl) + " " + this.index;
    }

    public String toString(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        String string = constantPool.constantToString(constant);
        if (constant instanceof ConstantClass) {
            string = string.replace('.', '/');
        }
        return Constants.OPCODE_NAMES[this.opcode] + " " + string;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int n) {
        this.index = n;
        if (this.index > 255 && this.opcode == 18) {
            this.opcode = (short)19;
        }
    }

    @Override
    public Type getType(ConstantPool constantPool) {
        switch (constantPool.getConstant(this.index).getTag()) {
            case 8: {
                return Type.STRING;
            }
            case 4: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.INT;
            }
            case 5: {
                return Type.LONG;
            }
            case 6: {
                return Type.DOUBLE;
            }
            case 7: {
                String string = constantPool.getConstantString_CONSTANTClass(this.index);
                if (!string.startsWith("[")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("L").append(string).append(";");
                    return Type.getType(stringBuffer.toString());
                }
                return Type.getType(string);
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    @Override
    public Object getValue(ConstantPool constantPool) {
        Constant constant = constantPool.getConstant(this.index);
        switch (constant.getTag()) {
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = constantPool.getConstant(n);
                return ((ConstantUtf8)constant).getValue();
            }
            case 4: {
                return ((ConstantFloat)constant).getValue();
            }
            case 3: {
                return ((ConstantInteger)constant).getValue();
            }
            case 5: {
                return ((ConstantLong)constant).getValue();
            }
            case 6: {
                return ((ConstantDouble)constant).getValue();
            }
        }
        throw new RuntimeException("Unknown or invalid constant type at " + this.index);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof InstructionCP)) {
            return false;
        }
        InstructionCP instructionCP = (InstructionCP)object;
        return instructionCP.opcode == this.opcode && instructionCP.index == this.index;
    }

    @Override
    public int hashCode() {
        return this.opcode * 37 + this.index;
    }
}

