/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.BasicType;
import org.aspectj.apache.bcel.generic.ClassGen;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.FieldInstruction;
import org.aspectj.apache.bcel.generic.INVOKEINTERFACE;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.InstructionBranch;
import org.aspectj.apache.bcel.generic.InstructionByte;
import org.aspectj.apache.bcel.generic.InstructionCP;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionHandle;
import org.aspectj.apache.bcel.generic.InstructionLV;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InstructionShort;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.MULTIANEWARRAY;
import org.aspectj.apache.bcel.generic.ObjectType;
import org.aspectj.apache.bcel.generic.ReferenceType;
import org.aspectj.apache.bcel.generic.Type;

public class InstructionFactory
implements InstructionConstants {
    protected ClassGen cg;
    protected ConstantPool cp;
    private static final char[] shortNames = new char[]{'C', 'F', 'D', 'B', 'S', 'I', 'L'};

    public InstructionFactory(ClassGen classGen, ConstantPool constantPool) {
        this.cg = classGen;
        this.cp = constantPool;
    }

    public InstructionFactory(ClassGen classGen) {
        this(classGen, classGen.getConstantPool());
    }

    public InstructionFactory(ConstantPool constantPool) {
        this(null, constantPool);
    }

    public InvokeInstruction createInvoke(String string, String string2, Type type, Type[] typeArray, short s) {
        int n;
        String string3 = Utility.toMethodSignature(type, typeArray);
        if (s == 185) {
            n = this.cp.addInterfaceMethodref(string, string2, string3);
        } else {
            if (s == 186) {
                throw new IllegalStateException("NYI");
            }
            n = this.cp.addMethodref(string, string2, string3);
        }
        switch (s) {
            case 183: {
                return new InvokeInstruction(183, n);
            }
            case 182: {
                return new InvokeInstruction(182, n);
            }
            case 184: {
                return new InvokeInstruction(184, n);
            }
            case 185: {
                int n2 = 0;
                for (int i = 0; i < typeArray.length; ++i) {
                    n2 += typeArray[i].getSize();
                }
                return new INVOKEINTERFACE(n, n2 + 1, 0);
            }
        }
        throw new RuntimeException("Oops: Unknown invoke kind:" + s);
    }

    public InvokeInstruction createInvoke(String string, String string2, String string3, short s) {
        int n;
        if (s == 185) {
            n = this.cp.addInterfaceMethodref(string, string2, string3);
        } else {
            if (s == 186) {
                throw new IllegalStateException("NYI");
            }
            n = this.cp.addMethodref(string, string2, string3);
        }
        switch (s) {
            case 183: {
                return new InvokeInstruction(183, n);
            }
            case 182: {
                return new InvokeInstruction(182, n);
            }
            case 184: {
                return new InvokeInstruction(184, n);
            }
            case 185: {
                Type[] typeArray = Type.getArgumentTypes(string3);
                int n2 = 0;
                for (int i = 0; i < typeArray.length; ++i) {
                    n2 += typeArray[i].getSize();
                }
                return new INVOKEINTERFACE(n, n2 + 1, 0);
            }
        }
        throw new RuntimeException("Oops: Unknown invoke kind:" + s);
    }

    public static Instruction createALOAD(int n) {
        if (n < 4) {
            return new InstructionLV((short)(42 + n));
        }
        return new InstructionLV(25, n);
    }

    public static Instruction createASTORE(int n) {
        if (n < 4) {
            return new InstructionLV((short)(75 + n));
        }
        return new InstructionLV(58, n);
    }

    public Instruction createConstant(Object object) {
        Instruction instruction;
        if (object instanceof Number) {
            instruction = InstructionFactory.PUSH(this.cp, (Number)object);
        } else if (object instanceof String) {
            instruction = InstructionFactory.PUSH(this.cp, (String)object);
        } else if (object instanceof Boolean) {
            instruction = InstructionFactory.PUSH(this.cp, (Boolean)object);
        } else if (object instanceof Character) {
            instruction = InstructionFactory.PUSH(this.cp, (Character)object);
        } else if (object instanceof ObjectType) {
            instruction = InstructionFactory.PUSH(this.cp, (ObjectType)object);
        } else {
            throw new ClassGenException("Illegal type: " + object.getClass());
        }
        return instruction;
    }

    public FieldInstruction createFieldAccess(String string, String string2, Type type, short s) {
        String string3 = type.getSignature();
        int n = this.cp.addFieldref(string, string2, string3);
        switch (s) {
            case 180: {
                return new FieldInstruction(180, n);
            }
            case 181: {
                return new FieldInstruction(181, n);
            }
            case 178: {
                return new FieldInstruction(178, n);
            }
            case 179: {
                return new FieldInstruction(179, n);
            }
        }
        throw new RuntimeException("Oops: Unknown getfield kind:" + s);
    }

    public static Instruction createThis() {
        return new InstructionLV(25, 0);
    }

    public static Instruction createReturn(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return ARETURN;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return IRETURN;
            }
            case 6: {
                return FRETURN;
            }
            case 7: {
                return DRETURN;
            }
            case 11: {
                return LRETURN;
            }
            case 12: {
                return RETURN;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public static Instruction createPop(int n) {
        return n == 2 ? POP2 : POP;
    }

    public static Instruction createDup(int n) {
        return n == 2 ? DUP2 : DUP;
    }

    public static Instruction createDup_2(int n) {
        return n == 2 ? DUP2_X2 : DUP_X2;
    }

    public static Instruction createDup_1(int n) {
        return n == 2 ? DUP2_X1 : DUP_X1;
    }

    public static InstructionLV createStore(Type type, int n) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new InstructionLV(54, n);
            }
            case 6: {
                return new InstructionLV(56, n);
            }
            case 7: {
                return new InstructionLV(57, n);
            }
            case 11: {
                return new InstructionLV(55, n);
            }
            case 13: 
            case 14: {
                return new InstructionLV(58, n);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static InstructionLV createLoad(Type type, int n) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new InstructionLV(21, n);
            }
            case 6: {
                return new InstructionLV(23, n);
            }
            case 7: {
                return new InstructionLV(24, n);
            }
            case 11: {
                return new InstructionLV(22, n);
            }
            case 13: 
            case 14: {
                return new InstructionLV(25, n);
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static Instruction createArrayLoad(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return BALOAD;
            }
            case 5: {
                return CALOAD;
            }
            case 9: {
                return SALOAD;
            }
            case 10: {
                return IALOAD;
            }
            case 6: {
                return FALOAD;
            }
            case 7: {
                return DALOAD;
            }
            case 11: {
                return LALOAD;
            }
            case 13: 
            case 14: {
                return AALOAD;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public static Instruction createArrayStore(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return BASTORE;
            }
            case 5: {
                return CASTORE;
            }
            case 9: {
                return SASTORE;
            }
            case 10: {
                return IASTORE;
            }
            case 6: {
                return FASTORE;
            }
            case 7: {
                return DASTORE;
            }
            case 11: {
                return LASTORE;
            }
            case 13: 
            case 14: {
                return AASTORE;
            }
        }
        throw new RuntimeException("Invalid type " + type);
    }

    public Instruction createCast(Type type, Type type2) {
        if (type instanceof BasicType && type2 instanceof BasicType) {
            byte by = type2.getType();
            int n = type.getType();
            if (by == 11 && (n == 5 || n == 8 || n == 9)) {
                n = 10;
            }
            if (n == 7) {
                switch (by) {
                    case 6: {
                        return InstructionConstants.D2F;
                    }
                    case 10: {
                        return InstructionConstants.D2I;
                    }
                    case 11: {
                        return InstructionConstants.D2L;
                    }
                }
            } else if (n == 6) {
                switch (by) {
                    case 7: {
                        return InstructionConstants.F2D;
                    }
                    case 10: {
                        return InstructionConstants.F2I;
                    }
                    case 11: {
                        return InstructionConstants.F2L;
                    }
                }
            } else if (n == 10) {
                switch (by) {
                    case 8: {
                        return InstructionConstants.I2B;
                    }
                    case 5: {
                        return InstructionConstants.I2C;
                    }
                    case 7: {
                        return InstructionConstants.I2D;
                    }
                    case 6: {
                        return InstructionConstants.I2F;
                    }
                    case 11: {
                        return InstructionConstants.I2L;
                    }
                    case 9: {
                        return InstructionConstants.I2S;
                    }
                }
            } else if (n == 11) {
                switch (by) {
                    case 7: {
                        return InstructionConstants.L2D;
                    }
                    case 6: {
                        return InstructionConstants.L2F;
                    }
                    case 10: {
                        return InstructionConstants.L2I;
                    }
                }
            }
            return null;
        }
        if (type instanceof ReferenceType && type2 instanceof ReferenceType) {
            if (type2 instanceof ArrayType) {
                return new InstructionCP(192, this.cp.addArrayClass((ArrayType)type2));
            }
            return new InstructionCP(192, this.cp.addClass(((ObjectType)type2).getClassName()));
        }
        throw new RuntimeException("Can not cast " + type + " to " + type2);
    }

    public FieldInstruction createGetField(String string, String string2, Type type) {
        return new FieldInstruction(180, this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public FieldInstruction createGetStatic(String string, String string2, Type type) {
        return new FieldInstruction(178, this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public FieldInstruction createPutField(String string, String string2, Type type) {
        return new FieldInstruction(181, this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public FieldInstruction createPutStatic(String string, String string2, Type type) {
        return new FieldInstruction(179, this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public Instruction createCheckCast(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            return new InstructionCP(192, this.cp.addArrayClass((ArrayType)referenceType));
        }
        return new InstructionCP(192, this.cp.addClass((ObjectType)referenceType));
    }

    public Instruction createInstanceOf(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            return new InstructionCP(193, this.cp.addArrayClass((ArrayType)referenceType));
        }
        return new InstructionCP(193, this.cp.addClass((ObjectType)referenceType));
    }

    public Instruction createNew(ObjectType objectType) {
        return new InstructionCP(187, this.cp.addClass(objectType));
    }

    public Instruction createNew(String string) {
        return this.createNew(new ObjectType(string));
    }

    public Instruction createNewArray(Type type, short s) {
        if (s == 1) {
            if (type instanceof ObjectType) {
                return new InstructionCP(189, this.cp.addClass((ObjectType)type));
            }
            if (type instanceof ArrayType) {
                return new InstructionCP(189, this.cp.addArrayClass((ArrayType)type));
            }
            return new InstructionByte(188, ((BasicType)type).getType());
        }
        ArrayType arrayType = type instanceof ArrayType ? (ArrayType)type : new ArrayType(type, (int)s);
        return new MULTIANEWARRAY(this.cp.addArrayClass(arrayType), s);
    }

    public static Instruction createNull(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return ACONST_NULL;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return ICONST_0;
            }
            case 6: {
                return FCONST_0;
            }
            case 7: {
                return DCONST_0;
            }
            case 11: {
                return LCONST_0;
            }
            case 12: {
                return NOP;
            }
        }
        throw new RuntimeException("Invalid type: " + type);
    }

    public static InstructionBranch createBranchInstruction(short s, InstructionHandle instructionHandle) {
        switch (s) {
            case 153: {
                return new InstructionBranch(153, instructionHandle);
            }
            case 154: {
                return new InstructionBranch(154, instructionHandle);
            }
            case 155: {
                return new InstructionBranch(155, instructionHandle);
            }
            case 156: {
                return new InstructionBranch(156, instructionHandle);
            }
            case 157: {
                return new InstructionBranch(157, instructionHandle);
            }
            case 158: {
                return new InstructionBranch(158, instructionHandle);
            }
            case 159: {
                return new InstructionBranch(159, instructionHandle);
            }
            case 160: {
                return new InstructionBranch(160, instructionHandle);
            }
            case 161: {
                return new InstructionBranch(161, instructionHandle);
            }
            case 162: {
                return new InstructionBranch(162, instructionHandle);
            }
            case 163: {
                return new InstructionBranch(163, instructionHandle);
            }
            case 164: {
                return new InstructionBranch(164, instructionHandle);
            }
            case 165: {
                return new InstructionBranch(165, instructionHandle);
            }
            case 166: {
                return new InstructionBranch(166, instructionHandle);
            }
            case 167: {
                return new InstructionBranch(167, instructionHandle);
            }
            case 168: {
                return new InstructionBranch(168, instructionHandle);
            }
            case 198: {
                return new InstructionBranch(198, instructionHandle);
            }
            case 199: {
                return new InstructionBranch(199, instructionHandle);
            }
            case 200: {
                return new InstructionBranch(200, instructionHandle);
            }
            case 201: {
                return new InstructionBranch(201, instructionHandle);
            }
        }
        throw new RuntimeException("Invalid opcode: " + s);
    }

    public void setClassGen(ClassGen classGen) {
        this.cg = classGen;
    }

    public ClassGen getClassGen() {
        return this.cg;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.cp = constantPool;
    }

    public ConstantPool getConstantPool() {
        return this.cp;
    }

    public static Instruction PUSH(ConstantPool constantPool, int n) {
        int n2;
        Instruction instruction = null;
        if (n >= -1 && n <= 5) {
            return INSTRUCTIONS[3 + n];
        }
        instruction = n >= -128 && n <= 127 ? new InstructionByte(16, (byte)n) : (n >= Short.MIN_VALUE && n <= Short.MAX_VALUE ? new InstructionShort(17, (short)n) : ((n2 = constantPool.addInteger(n)) <= 255 ? new InstructionCP(18, n2) : new InstructionCP(19, n2)));
        return instruction;
    }

    public static Instruction PUSH(ConstantPool constantPool, ObjectType objectType) {
        return new InstructionCP(19, constantPool.addClass(objectType));
    }

    public static Instruction PUSH(ConstantPool constantPool, boolean bl) {
        return INSTRUCTIONS[3 + (bl ? 1 : 0)];
    }

    public static Instruction PUSH(ConstantPool constantPool, float f) {
        int n;
        Instruction instruction = null;
        instruction = (double)f == 0.0 ? FCONST_0 : ((double)f == 1.0 ? FCONST_1 : ((double)f == 2.0 ? FCONST_2 : new InstructionCP((n = constantPool.addFloat(f)) <= 255 ? (short)18 : 19, n)));
        return instruction;
    }

    public static Instruction PUSH(ConstantPool constantPool, long l) {
        Instruction instruction = null;
        instruction = l == 0L ? LCONST_0 : (l == 1L ? LCONST_1 : new InstructionCP(20, constantPool.addLong(l)));
        return instruction;
    }

    public static Instruction PUSH(ConstantPool constantPool, double d) {
        Instruction instruction = null;
        instruction = d == 0.0 ? DCONST_0 : (d == 1.0 ? DCONST_1 : new InstructionCP(20, constantPool.addDouble(d)));
        return instruction;
    }

    public static Instruction PUSH(ConstantPool constantPool, String string) {
        int n;
        Instruction instruction = null;
        instruction = string == null ? ACONST_NULL : new InstructionCP((n = constantPool.addString(string)) <= 255 ? (short)18 : 19, n);
        return instruction;
    }

    public static Instruction PUSH(ConstantPool constantPool, Number number) {
        Instruction instruction = null;
        if (number instanceof Integer || number instanceof Short || number instanceof Byte) {
            instruction = InstructionFactory.PUSH(constantPool, number.intValue());
        } else if (number instanceof Double) {
            instruction = InstructionFactory.PUSH(constantPool, number.doubleValue());
        } else if (number instanceof Float) {
            instruction = InstructionFactory.PUSH(constantPool, number.floatValue());
        } else if (number instanceof Long) {
            instruction = InstructionFactory.PUSH(constantPool, number.longValue());
        } else {
            throw new ClassGenException("What's this: " + number);
        }
        return instruction;
    }

    public static Instruction PUSH(ConstantPool constantPool, Character c) {
        return InstructionFactory.PUSH(constantPool, (int)c.charValue());
    }

    public static Instruction PUSH(ConstantPool constantPool, Boolean bl) {
        return InstructionFactory.PUSH(constantPool, (boolean)bl);
    }

    public InstructionList PUSHCLASS(ConstantPool constantPool, String string) {
        InstructionList instructionList = new InstructionList();
        int n = constantPool.addClass(string);
        if (this.cg != null && this.cg.getMajor() >= 49) {
            if (n <= 255) {
                instructionList.append(new InstructionCP(18, n));
            } else {
                instructionList.append(new InstructionCP(19, n));
            }
        } else {
            instructionList.append(InstructionFactory.PUSH(constantPool, string));
            instructionList.append(this.createInvoke("java.lang.Class", "forName", ObjectType.CLASS, Type.STRINGARRAY1, (short)184));
        }
        return instructionList;
    }
}

