/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.util.ClassLoaderReference;
import org.aspectj.apache.bcel.util.DefaultClassLoaderReference;
import org.aspectj.apache.bcel.util.Repository;

public class ClassLoaderRepository
implements Repository {
    private static ClassLoader bootClassLoader = null;
    private ClassLoaderReference loaderRef;
    private WeakHashMap<URL, SoftReference<JavaClass>> localCache = new WeakHashMap();
    private static SoftHashMap sharedCache = new SoftHashMap(Collections.synchronizedMap(new HashMap()));
    private SoftHashMap nameMap = new SoftHashMap(new HashMap(), false);
    public static boolean useSharedCache = System.getProperty("org.aspectj.apache.bcel.useSharedCache", "true").equalsIgnoreCase("true");
    private static int cacheHitsShared = 0;
    private static int missSharedEvicted = 0;
    private long timeManipulatingURLs = 0L;
    private long timeSpentLoading = 0L;
    private int classesLoadedCount = 0;
    private int misses = 0;
    private int cacheHitsLocal = 0;
    private int missLocalEvicted = 0;

    public ClassLoaderRepository(ClassLoader classLoader) {
        this.loaderRef = new DefaultClassLoaderReference(classLoader != null ? classLoader : ClassLoaderRepository.getBootClassLoader());
    }

    public ClassLoaderRepository(ClassLoaderReference classLoaderReference) {
        this.loaderRef = classLoaderReference;
    }

    private static synchronized ClassLoader getBootClassLoader() {
        if (bootClassLoader == null) {
            bootClassLoader = new URLClassLoader(new URL[0]);
        }
        return bootClassLoader;
    }

    private void storeClassAsReference(URL uRL, JavaClass javaClass) {
        if (useSharedCache) {
            javaClass.setRepository(null);
            sharedCache.put(uRL, javaClass);
        } else {
            javaClass.setRepository(this);
            this.localCache.put(uRL, new SoftReference<JavaClass>(javaClass));
        }
    }

    @Override
    public void storeClass(JavaClass javaClass) {
        this.storeClassAsReference(this.toURL(javaClass.getClassName()), javaClass);
    }

    @Override
    public void removeClass(JavaClass javaClass) {
        if (useSharedCache) {
            sharedCache.remove(this.toURL(javaClass.getClassName()));
        } else {
            this.localCache.remove(this.toURL(javaClass.getClassName()));
        }
    }

    @Override
    public JavaClass findClass(String string) {
        if (useSharedCache) {
            return this.findClassShared(this.toURL(string));
        }
        return this.findClassLocal(this.toURL(string));
    }

    private JavaClass findClassLocal(URL uRL) {
        SoftReference<JavaClass> softReference = this.localCache.get(uRL);
        if (softReference != null) {
            if ((softReference = ((Reference)softReference).get()) != null) {
                return (JavaClass)((Object)softReference);
            }
            ++this.missLocalEvicted;
        }
        return null;
    }

    private JavaClass findClassShared(URL uRL) {
        return (JavaClass)sharedCache.get(uRL);
    }

    private URL toURL(String string) {
        URL uRL = (URL)this.nameMap.get(string);
        if (uRL == null) {
            String string2 = string.replace('.', '/');
            uRL = this.loaderRef.getClassLoader().getResource(string2 + ".class");
            this.nameMap.put(string, uRL);
        }
        return uRL;
    }

    @Override
    public JavaClass loadClass(String string) throws ClassNotFoundException {
        long l = System.currentTimeMillis();
        URL uRL = this.toURL(string);
        this.timeManipulatingURLs += System.currentTimeMillis() - l;
        if (uRL == null) {
            throw new ClassNotFoundException(string + " not found - unable to determine URL");
        }
        JavaClass javaClass = null;
        if (useSharedCache) {
            javaClass = this.findClassShared(uRL);
            if (javaClass != null) {
                ++cacheHitsShared;
                return javaClass;
            }
        } else {
            javaClass = this.findClassLocal(uRL);
            if (javaClass != null) {
                ++this.cacheHitsLocal;
                return javaClass;
            }
        }
        ++this.misses;
        try {
            InputStream inputStream;
            String string2 = string.replace('.', '/');
            InputStream inputStream2 = inputStream = useSharedCache ? uRL.openStream() : this.loaderRef.getClassLoader().getResourceAsStream(string2 + ".class");
            if (inputStream == null) {
                throw new ClassNotFoundException(string + " not found using url " + uRL);
            }
            ClassParser classParser = new ClassParser(inputStream, string);
            javaClass = classParser.parse();
            this.storeClassAsReference(uRL, javaClass);
            this.timeSpentLoading += System.currentTimeMillis() - l;
            ++this.classesLoadedCount;
            return javaClass;
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(iOException.toString());
        }
    }

    public String report() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BCEL repository report.");
        if (useSharedCache) {
            stringBuffer.append(" (shared cache)");
        } else {
            stringBuffer.append(" (local cache)");
        }
        stringBuffer.append(" Total time spent loading: " + this.timeSpentLoading + "ms.");
        stringBuffer.append(" Time spent manipulating URLs: " + this.timeManipulatingURLs + "ms.");
        stringBuffer.append(" Classes loaded: " + this.classesLoadedCount + ".");
        if (useSharedCache) {
            stringBuffer.append(" Shared cache size: " + sharedCache.size());
            stringBuffer.append(" Shared cache (hits/missDueToEviction): (" + cacheHitsShared + "/" + missSharedEvicted + ").");
        } else {
            stringBuffer.append(" Local cache size: " + this.localCache.size());
            stringBuffer.append(" Local cache (hits/missDueToEviction): (" + this.cacheHitsLocal + "/" + this.missLocalEvicted + ").");
        }
        return stringBuffer.toString();
    }

    public long[] reportStats() {
        return new long[]{this.timeSpentLoading, this.timeManipulatingURLs, this.classesLoadedCount, cacheHitsShared, missSharedEvicted, this.cacheHitsLocal, this.missLocalEvicted, sharedCache.size()};
    }

    public void reset() {
        this.timeManipulatingURLs = 0L;
        this.timeSpentLoading = 0L;
        this.classesLoadedCount = 0;
        this.cacheHitsLocal = 0;
        cacheHitsShared = 0;
        missSharedEvicted = 0;
        this.missLocalEvicted = 0;
        this.misses = 0;
        this.clear();
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        if (useSharedCache) {
            sharedCache.clear();
        } else {
            this.localCache.clear();
        }
    }

    public static class SoftHashMap
    extends AbstractMap {
        private Map<Object, SpecialValue> map;
        boolean recordMiss = true;
        private ReferenceQueue rq = new ReferenceQueue();

        public SoftHashMap(Map<Object, SpecialValue> map) {
            this.map = map;
        }

        public SoftHashMap() {
            this(new HashMap<Object, SpecialValue>());
        }

        public SoftHashMap(Map map, boolean bl) {
            this(map);
            this.recordMiss = bl;
        }

        private void processQueue() {
            SpecialValue specialValue = null;
            while ((specialValue = (SpecialValue)this.rq.poll()) != null) {
                this.map.remove(specialValue.key);
            }
        }

        @Override
        public Object get(Object object) {
            SpecialValue specialValue = this.map.get(object);
            if (specialValue == null) {
                return null;
            }
            if (specialValue.get() == null) {
                this.map.remove(specialValue.key);
                if (this.recordMiss) {
                    missSharedEvicted++;
                }
                return null;
            }
            return specialValue.get();
        }

        @Override
        public Object put(Object object, Object object2) {
            this.processQueue();
            return this.map.put(object, new SpecialValue(object, object2));
        }

        @Override
        public Set entrySet() {
            return this.map.entrySet();
        }

        @Override
        public void clear() {
            this.processQueue();
            this.map.clear();
        }

        @Override
        public int size() {
            this.processQueue();
            return this.map.size();
        }

        @Override
        public Object remove(Object object) {
            this.processQueue();
            SpecialValue specialValue = this.map.remove(object);
            if (specialValue == null) {
                return null;
            }
            if (specialValue.get() != null) {
                return specialValue.get();
            }
            return null;
        }

        class SpecialValue
        extends SoftReference {
            private final Object key;

            SpecialValue(Object object, Object object2) {
                super(object2, SoftHashMap.this.rq);
                this.key = object;
            }
        }
    }
}

