/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.util.ClassPath;
import org.aspectj.apache.bcel.util.Repository;

public class SyntheticRepository
implements Repository {
    private static final String DEFAULT_PATH = ClassPath.getClassPath();
    private static HashMap<ClassPath, SyntheticRepository> _instances = new HashMap();
    private ClassPath _path = null;
    private WeakHashMap<String, JavaClass> _loadedClasses = new WeakHashMap();

    private SyntheticRepository(ClassPath classPath) {
        this._path = classPath;
    }

    public static SyntheticRepository getInstance() {
        return SyntheticRepository.getInstance(ClassPath.getSystemClassPath());
    }

    public static SyntheticRepository getInstance(ClassPath classPath) {
        SyntheticRepository syntheticRepository = _instances.get(classPath);
        if (syntheticRepository == null) {
            syntheticRepository = new SyntheticRepository(classPath);
            _instances.put(classPath, syntheticRepository);
        }
        return syntheticRepository;
    }

    @Override
    public void storeClass(JavaClass javaClass) {
        this._loadedClasses.put(javaClass.getClassName(), javaClass);
        javaClass.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass javaClass) {
        this._loadedClasses.remove(javaClass.getClassName());
    }

    @Override
    public JavaClass findClass(String string) {
        return this._loadedClasses.get(string);
    }

    @Override
    public JavaClass loadClass(String string) throws ClassNotFoundException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException("Invalid class name " + string);
        }
        string = string.replace('/', '.');
        try {
            return this.loadClass(this._path.getInputStream(string), string);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException.toString());
        }
    }

    @Override
    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        String string = clazz.getName();
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        return this.loadClass(clazz.getResourceAsStream(string2 + ".class"), string);
    }

    private JavaClass loadClass(InputStream inputStream, String string) throws ClassNotFoundException {
        JavaClass javaClass = this.findClass(string);
        if (javaClass != null) {
            return javaClass;
        }
        try {
            if (inputStream != null) {
                ClassParser classParser = new ClassParser(inputStream, string);
                javaClass = classParser.parse();
                this.storeClass(javaClass);
                return javaClass;
            }
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Exception while looking for class " + string + ": " + iOException.toString());
        }
        throw new ClassNotFoundException("SyntheticRepository could not load " + string);
    }

    @Override
    public void clear() {
        this._loadedClasses.clear();
    }
}

