/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.lite.internal.schedule;

import org.apache.shardingsphere.elasticjob.lite.internal.election.LeaderService;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobRegistry;
import org.apache.shardingsphere.elasticjob.lite.internal.schedule.JobTriggerListener;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ExecutionService;
import org.apache.shardingsphere.elasticjob.lite.internal.sharding.ShardingService;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class SchedulerFacade {
    private final String jobName;
    private final LeaderService leaderService;
    private final ShardingService shardingService;
    private final ExecutionService executionService;

    public SchedulerFacade(CoordinatorRegistryCenter regCenter, String jobName) {
        this.jobName = jobName;
        this.leaderService = new LeaderService(regCenter, jobName);
        this.shardingService = new ShardingService(regCenter, jobName);
        this.executionService = new ExecutionService(regCenter, jobName);
    }

    public JobTriggerListener newJobTriggerListener() {
        return new JobTriggerListener(this.executionService, this.shardingService);
    }

    public void shutdownInstance() {
        if (this.leaderService.isLeader()) {
            this.leaderService.removeLeader();
        }
        JobRegistry.getInstance().shutdown(this.jobName);
    }
}

