/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.Extent;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProviderIterator;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.ReferenceHashSet;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.OpenJPAException;

public class ExtentImpl<T>
implements Extent<T> {
    private static final ClassMetaData[] EMPTY_METAS = new ClassMetaData[0];
    private final Broker _broker;
    private final Class<T> _type;
    private final boolean _subs;
    private final FetchConfiguration _fc;
    private final ReentrantLock _lock;
    private boolean _ignore = false;
    private ReferenceHashSet _openItrs = null;

    ExtentImpl(Broker broker, Class<T> type, boolean subs, FetchConfiguration fetch) {
        this._broker = broker;
        this._type = type;
        this._subs = subs;
        this._fc = fetch != null ? fetch : (FetchConfiguration)broker.getFetchConfiguration().clone();
        this._ignore = broker.getIgnoreChanges();
        this._lock = broker.getMultithreaded() ? new ReentrantLock() : null;
    }

    @Override
    public FetchConfiguration getFetchConfiguration() {
        return this._fc;
    }

    @Override
    public boolean getIgnoreChanges() {
        return this._ignore;
    }

    @Override
    public void setIgnoreChanges(boolean ignoreChanges) {
        this._broker.assertOpen();
        this._ignore = ignoreChanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> list() {
        ArrayList<T> list = new ArrayList<T>();
        Iterator<T> itr = this.iterator();
        try {
            while (itr.hasNext()) {
                list.add(itr.next());
            }
            ArrayList<T> arrayList = list;
            return arrayList;
        }
        finally {
            ImplHelper.close(itr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        this._broker.assertNontransactionalRead();
        CloseableIterator citr = null;
        try {
            MetaDataRepository repos;
            ClassMetaData meta;
            boolean trans;
            CloseableIteratorChain chain = new CloseableIteratorChain();
            boolean bl = trans = !this._ignore && this._broker.isActive();
            if (trans) {
                chain.addIterator((Iterator)((Object)new FilterNewIterator()));
            }
            ClassMetaData[] metas = (meta = (repos = this._broker.getConfiguration().getMetaDataRepositoryInstance()).getMetaData(this._type, this._broker.getClassLoader(), false)) != null && (!this._subs || !meta.isManagedInterface()) && (meta.isMapped() || this._subs && meta.getMappedPCSubclassMetaDatas().length > 0) ? new ClassMetaData[]{meta} : (this._subs && (meta == null || meta.isManagedInterface()) ? repos.getImplementorMetaDatas(this._type, this._broker.getClassLoader(), false) : EMPTY_METAS);
            for (int i = 0; i < metas.length; ++i) {
                ResultObjectProvider rop = this._broker.getStoreManager().executeExtent(metas[i], this._subs, this._fc);
                if (rop == null) continue;
                chain.addIterator(new ResultObjectProviderIterator(rop));
            }
            citr = trans ? new FilterDeletedIterator(chain) : chain;
            citr.setRemoveOnClose(this);
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        this.lock();
        try {
            if (this._openItrs == null) {
                this._openItrs = new ReferenceHashSet(AbstractReferenceMap.ReferenceStrength.WEAK);
            }
            this._openItrs.add(citr);
        }
        finally {
            this.unlock();
        }
        return citr;
    }

    @Override
    public Broker getBroker() {
        return this._broker;
    }

    @Override
    public Class<T> getElementType() {
        return this._type;
    }

    @Override
    public boolean hasSubclasses() {
        return this._subs;
    }

    @Override
    public void closeAll() {
        if (this._openItrs == null) {
            return;
        }
        this.lock();
        try {
            for (CloseableIterator citr : this._openItrs) {
                citr.setRemoveOnClose(null);
                try {
                    citr.close();
                }
                catch (Exception exception) {}
            }
            this._openItrs.clear();
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void lock() {
        if (this._lock != null) {
            this._lock.lock();
        }
    }

    @Override
    public void unlock() {
        if (this._lock != null) {
            this._lock.unlock();
        }
    }

    private class FilterNewIterator
    extends FilterIterator
    implements Closeable,
    Predicate {
        public FilterNewIterator() {
            super(ExtentImpl.this._broker.getTransactionalObjects().iterator());
            this.setPredicate(this);
        }

        @Override
        public void close() {
        }

        public boolean evaluate(Object o) {
            if (!ExtentImpl.this._broker.isNew(o)) {
                return false;
            }
            Class<?> type = o.getClass();
            if (!ExtentImpl.this._subs && type != ExtentImpl.this._type) {
                return false;
            }
            return !ExtentImpl.this._subs || ExtentImpl.this._type.isAssignableFrom(type);
        }
    }

    private static class FilterDeletedIterator
    extends FilterIterator
    implements CloseableIterator,
    Predicate {
        private ExtentImpl _extent = null;
        private boolean _closed = false;

        public FilterDeletedIterator(Iterator itr) {
            super(itr);
            this.setPredicate(this);
        }

        @Override
        public boolean hasNext() {
            return this._closed ? false : super.hasNext();
        }

        @Override
        public Object next() {
            if (this._closed) {
                throw new NoSuchElementException();
            }
            return super.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void setRemoveOnClose(ExtentImpl extent) {
            this._extent = extent;
        }

        @Override
        public void close() throws Exception {
            if (this._extent != null && this._extent._openItrs != null) {
                this._extent.lock();
                try {
                    this._extent._openItrs.remove(this);
                }
                finally {
                    this._extent.unlock();
                }
            }
            this._closed = true;
            ((Closeable)((Object)this.getIterator())).close();
        }

        public boolean evaluate(Object o) {
            return !this._extent._broker.isDeleted(o);
        }
    }

    private static class CloseableIteratorChain
    extends IteratorChain
    implements CloseableIterator {
        private ExtentImpl<?> _extent = null;
        private boolean _closed = false;

        private CloseableIteratorChain() {
        }

        @Override
        public boolean hasNext() {
            return this._closed ? false : super.hasNext();
        }

        @Override
        public Object next() {
            if (this._closed) {
                throw new NoSuchElementException();
            }
            return super.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void setRemoveOnClose(ExtentImpl extent) {
            this._extent = extent;
        }

        @Override
        public void close() throws Exception {
            if (this._extent != null && ((ExtentImpl)this._extent)._openItrs != null) {
                this._extent.lock();
                try {
                    ((ExtentImpl)this._extent)._openItrs.remove(this);
                }
                finally {
                    this._extent.unlock();
                }
            }
            this._closed = true;
            CloseableIteratorChain itr = this;
            while (itr.hasNext()) {
                ((Closeable)itr.next()).close();
            }
        }
    }

    private static interface CloseableIterator<T>
    extends Closeable,
    Iterator<T> {
        public void setRemoveOnClose(ExtentImpl<T> var1);
    }
}

