/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel;

import java.io.IOException;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.util.ClassPath;
import org.aspectj.apache.bcel.util.SyntheticRepository;

public abstract class Repository {
    private static org.aspectj.apache.bcel.util.Repository _repository = null;

    public static org.aspectj.apache.bcel.util.Repository getRepository() {
        if (_repository == null) {
            _repository = SyntheticRepository.getInstance();
        }
        return _repository;
    }

    public static void setRepository(org.aspectj.apache.bcel.util.Repository repository) {
        _repository = repository;
    }

    public static JavaClass lookupClass(String string) {
        try {
            JavaClass javaClass = Repository.getRepository().findClass(string);
            if (javaClass != null) {
                return javaClass;
            }
            return Repository.getRepository().loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static ClassPath.ClassFile lookupClassFile(String string) {
        try {
            return ClassPath.getSystemClassPath().getClassFile(string);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void clearCache() {
        Repository.getRepository().clear();
    }

    public static JavaClass addClass(JavaClass javaClass) {
        JavaClass javaClass2 = Repository.getRepository().findClass(javaClass.getClassName());
        Repository.getRepository().storeClass(javaClass);
        return javaClass2;
    }

    public static void removeClass(String string) {
        Repository.getRepository().removeClass(Repository.getRepository().findClass(string));
    }

    public static boolean instanceOf(JavaClass javaClass, JavaClass javaClass2) {
        return javaClass.instanceOf(javaClass2);
    }

    public static boolean instanceOf(String string, String string2) {
        return Repository.instanceOf(Repository.lookupClass(string), Repository.lookupClass(string2));
    }

    public static boolean implementationOf(JavaClass javaClass, JavaClass javaClass2) {
        return javaClass.implementationOf(javaClass2);
    }

    public static boolean implementationOf(String string, String string2) {
        return Repository.implementationOf(Repository.lookupClass(string), Repository.lookupClass(string2));
    }
}

