/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;

public final class ClassParser {
    private DataInputStream file;
    private String filename;
    private int classnameIndex;
    private int superclassnameIndex;
    private int major;
    private int minor;
    private int accessflags;
    private int[] interfaceIndices;
    private ConstantPool cpool;
    private Field[] fields;
    private Method[] methods;
    private Attribute[] attributes;
    private static final int BUFSIZE = 8192;
    private static final int[] NO_INTERFACES = new int[0];

    public ClassParser(InputStream inputStream, String string) {
        this.filename = string;
        this.file = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(new BufferedInputStream(inputStream, 8192));
    }

    public ClassParser(ByteArrayInputStream byteArrayInputStream, String string) {
        this.filename = string;
        this.file = new DataInputStream(byteArrayInputStream);
    }

    public ClassParser(String string) throws IOException {
        this.filename = string;
        this.file = new DataInputStream(new BufferedInputStream(new FileInputStream(string), 8192));
    }

    public JavaClass parse() throws IOException, ClassFormatException {
        this.readID();
        this.readVersion();
        this.readConstantPool();
        this.readClassInfo();
        this.readInterfaces();
        this.readFields();
        this.readMethods();
        this.readAttributes();
        this.file.close();
        JavaClass javaClass = new JavaClass(this.classnameIndex, this.superclassnameIndex, this.filename, this.major, this.minor, this.accessflags, this.cpool, this.interfaceIndices, this.fields, this.methods, this.attributes);
        return javaClass;
    }

    private final void readAttributes() {
        this.attributes = AttributeUtils.readAttributes(this.file, this.cpool);
    }

    private final void readClassInfo() throws IOException {
        this.accessflags = this.file.readUnsignedShort();
        if ((this.accessflags & 0x200) != 0) {
            this.accessflags |= 0x400;
        }
        this.classnameIndex = this.file.readUnsignedShort();
        this.superclassnameIndex = this.file.readUnsignedShort();
    }

    private final void readConstantPool() throws IOException {
        try {
            this.cpool = new ConstantPool(this.file);
        }
        catch (ClassFormatException classFormatException) {
            classFormatException.printStackTrace();
            if (this.filename != null) {
                String string = "File: '" + this.filename + "': " + classFormatException.getMessage();
                throw new ClassFormatException(string);
            }
            throw classFormatException;
        }
    }

    private final void readFields() throws IOException, ClassFormatException {
        int n = this.file.readUnsignedShort();
        if (n == 0) {
            this.fields = Field.NoFields;
        } else {
            this.fields = new Field[n];
            for (int i = 0; i < n; ++i) {
                this.fields[i] = new Field(this.file, this.cpool);
            }
        }
    }

    private final void readID() throws IOException {
        int n = -889275714;
        if (this.file.readInt() != n) {
            throw new ClassFormatException(this.filename + " is not a Java .class file");
        }
    }

    private final void readInterfaces() throws IOException {
        int n = this.file.readUnsignedShort();
        if (n == 0) {
            this.interfaceIndices = NO_INTERFACES;
        } else {
            this.interfaceIndices = new int[n];
            for (int i = 0; i < n; ++i) {
                this.interfaceIndices[i] = this.file.readUnsignedShort();
            }
        }
    }

    private final void readMethods() throws IOException {
        int n = this.file.readUnsignedShort();
        if (n == 0) {
            this.methods = Method.NoMethods;
        } else {
            this.methods = new Method[n];
            for (int i = 0; i < n; ++i) {
                this.methods[i] = new Method(this.file, this.cpool);
            }
        }
    }

    private final void readVersion() throws IOException {
        this.minor = this.file.readUnsignedShort();
        this.major = this.file.readUnsignedShort();
    }
}

