/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.annotation.ElementValue;
import org.aspectj.apache.bcel.generic.ObjectType;

public class ClassElementValue
extends ElementValue {
    private int idx;

    protected ClassElementValue(int n, ConstantPool constantPool) {
        super(99, constantPool);
        this.idx = n;
    }

    public ClassElementValue(ObjectType objectType, ConstantPool constantPool) {
        super(99, constantPool);
        this.idx = constantPool.addUtf8(objectType.getSignature());
    }

    public ClassElementValue(ClassElementValue classElementValue, ConstantPool constantPool, boolean bl) {
        super(99, constantPool);
        this.idx = bl ? constantPool.addUtf8(classElementValue.getClassString()) : classElementValue.getIndex();
    }

    public int getIndex() {
        return this.idx;
    }

    public String getClassString() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.getConstantPool().getConstant(this.idx);
        return constantUtf8.getValue();
    }

    @Override
    public String stringifyValue() {
        return this.getClassString();
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.type);
        dataOutputStream.writeShort(this.idx);
    }
}

