/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;

public abstract class RuntimeParamAnnos
extends Attribute {
    private List<AnnotationGen[]> parameterAnnotations;
    private boolean visible;
    private boolean inflated = false;
    private byte[] annotation_data;

    public RuntimeParamAnnos(byte by, boolean bl, int n, int n2, ConstantPool constantPool) {
        super(by, n, n2, constantPool);
        this.visible = bl;
        this.parameterAnnotations = new ArrayList<AnnotationGen[]>();
    }

    public RuntimeParamAnnos(byte by, boolean bl, int n, int n2, byte[] byArray, ConstantPool constantPool) {
        super(by, n, n2, constantPool);
        this.visible = bl;
        this.parameterAnnotations = new ArrayList<AnnotationGen[]>();
        this.annotation_data = byArray;
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        this.writeAnnotations(dataOutputStream);
    }

    public Attribute copy(ConstantPool constantPool) {
        throw new RuntimeException("Not implemented yet!");
    }

    public List<AnnotationGen[]> getParameterAnnotations() {
        if (!this.inflated) {
            this.inflate();
        }
        return this.parameterAnnotations;
    }

    public AnnotationGen[] getAnnotationsOnParameter(int n) {
        if (!this.inflated) {
            this.inflate();
        }
        if (n >= this.parameterAnnotations.size()) {
            return AnnotationGen.NO_ANNOTATIONS;
        }
        return this.parameterAnnotations.get(n);
    }

    public boolean areVisible() {
        return this.visible;
    }

    protected void readParameterAnnotations(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        this.annotation_data = new byte[this.length];
        dataInputStream.readFully(this.annotation_data, 0, this.length);
    }

    private void inflate() {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.annotation_data));
            int n = dataInputStream.readUnsignedByte();
            if (n > 0) {
                ArrayList<AnnotationGen[]> arrayList = new ArrayList<AnnotationGen[]>();
                for (int i = 0; i < n; ++i) {
                    int n2 = dataInputStream.readUnsignedShort();
                    if (n2 == 0) {
                        arrayList.add(AnnotationGen.NO_ANNOTATIONS);
                        continue;
                    }
                    AnnotationGen[] annotationGenArray = new AnnotationGen[n2];
                    for (int j = 0; j < n2; ++j) {
                        annotationGenArray[j] = AnnotationGen.read(dataInputStream, this.getConstantPool(), this.visible);
                    }
                    arrayList.add(annotationGenArray);
                }
                this.parameterAnnotations = arrayList;
            }
            this.inflated = true;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unabled to inflate annotation data, badly formed?");
        }
    }

    protected void writeAnnotations(DataOutputStream dataOutputStream) throws IOException {
        if (!this.inflated) {
            dataOutputStream.write(this.annotation_data, 0, this.length);
        } else {
            dataOutputStream.writeByte(this.parameterAnnotations.size());
            for (int i = 0; i < this.parameterAnnotations.size(); ++i) {
                AnnotationGen[] annotationGenArray = this.parameterAnnotations.get(i);
                dataOutputStream.writeShort(annotationGenArray.length);
                for (int j = 0; j < annotationGenArray.length; ++j) {
                    annotationGenArray[j].dump(dataOutputStream);
                }
            }
        }
    }

    public boolean isInflated() {
        return this.inflated;
    }

    @Override
    public String toString() {
        return "Runtime" + (this.visible ? "Visible" : "Invisible") + "ParameterAnnotations [" + (this.inflated ? "inflated" : "not yet inflated") + "]";
    }
}

