/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.registry.nacos;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingFactory;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.apache.shenyu.registry.api.entity.InstanceEntity;
import org.apache.shenyu.registry.api.event.ChangedEventListener;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class NacosInstanceRegisterRepository
implements ShenyuInstanceRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosInstanceRegisterRepository.class);
    private static final String NAMESPACE = "nacosNameSpace";
    private final ConcurrentMap<String, EventListener> listenerMap = new ConcurrentHashMap<String, EventListener>();
    private final ConcurrentMap<String, List<Instance>> instanceListMap = new ConcurrentHashMap<String, List<Instance>>();
    private NamingService namingService;
    private String groupName;

    public void init(RegisterConfig config) {
        Properties properties = config.getProps();
        Properties nacosProperties = new Properties();
        this.groupName = properties.getProperty("groupName", "DEFAULT_GROUP");
        String serverAddr = config.getServerLists();
        nacosProperties.put("serverAddr", serverAddr);
        nacosProperties.put("namespace", properties.getProperty(NAMESPACE, ""));
        nacosProperties.put("username", properties.getProperty("username", ""));
        nacosProperties.put("password", properties.getProperty("password", ""));
        nacosProperties.put("accessKey", properties.getProperty("accessKey", ""));
        nacosProperties.put("secretKey", properties.getProperty("secretKey", ""));
        try {
            LOGGER.info("nacos registry init...");
            this.namingService = NamingFactory.createNamingService((Properties)nacosProperties);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public void persistInstance(InstanceEntity instance) {
        try {
            Instance inst = new Instance();
            inst.setWeight(1.0);
            inst.setEphemeral(true);
            inst.setIp(instance.getHost());
            inst.setPort(instance.getPort().intValue());
            inst.setInstanceId(this.buildInstanceNodeName(instance));
            inst.setServiceName(instance.getAppName());
            this.namingService.registerInstance(instance.getAppName(), this.groupName, inst);
            LOGGER.info("nacos registry persistInstance success: {}", (Object)inst);
        }
        catch (NacosException e) {
            throw new ShenyuException((Throwable)e);
        }
    }

    public List<InstanceEntity> selectInstances(String selectKey) {
        return this.getInstanceRegisterDTOS(selectKey);
    }

    public boolean serviceExists(String key) {
        try {
            List instances = this.namingService.selectInstances(key, this.groupName, true);
            return !instances.isEmpty();
        }
        catch (NacosException e) {
            LOGGER.error("nacos registry Error checking Nacos service existence: {}", (Object)e.getMessage(), (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public void watchInstances(String key, ChangedEventListener listener) {
        try {
            List initialInstances = this.namingService.selectInstances(key, this.groupName, true);
            this.instanceListMap.put(key, initialInstances);
            for (Instance instance : initialInstances) {
                listener.onEvent(key, this.buildUpstreamJsonFromInstance(instance), ChangedEventListener.Event.ADDED);
            }
            EventListener nacosListener = event -> {
                if (event instanceof NamingEvent) {
                    try {
                        List previousInstances = (List)this.instanceListMap.get(key);
                        List currentInstances = this.namingService.selectInstances(key, this.groupName, true);
                        this.compareInstances(previousInstances, currentInstances, listener);
                        this.instanceListMap.put(key, currentInstances);
                    }
                    catch (NacosException e) {
                        throw new ShenyuException((Throwable)e);
                    }
                }
            };
            this.namingService.subscribe(key, this.groupName, nacosListener);
            this.listenerMap.put(key, nacosListener);
            LOGGER.info("nacos registry subscribed to nacos updates for key: {}", (Object)key);
        }
        catch (NacosException e) {
            LOGGER.error("nacos registry error watching key: {}", (Object)key, (Object)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    public void unWatchInstances(String key) {
        try {
            EventListener nacosListener = (EventListener)this.listenerMap.get(key);
            if (Objects.nonNull(nacosListener)) {
                this.namingService.unsubscribe(key, this.groupName, nacosListener);
                this.listenerMap.remove(key);
                LOGGER.info("nacos registry unwatch key: {}", (Object)key);
            }
        }
        catch (NacosException e) {
            LOGGER.error("nacos registry error removing nacos service listener...", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
    }

    private void compareInstances(List<Instance> previousInstances, List<Instance> currentInstances, ChangedEventListener listener) {
        Set updatedInstances;
        Set deletedInstances;
        Set addedInstances = currentInstances.stream().filter(item -> !previousInstances.contains(item)).collect(Collectors.toSet());
        if (!addedInstances.isEmpty()) {
            for (Object instance : addedInstances) {
                listener.onEvent(instance.getServiceName(), this.buildUpstreamJsonFromInstance((Instance)instance), ChangedEventListener.Event.ADDED);
            }
        }
        if (!(deletedInstances = previousInstances.stream().filter(item -> !currentInstances.contains(item)).collect(Collectors.toSet())).isEmpty()) {
            for (Instance instance : deletedInstances) {
                instance.setHealthy(false);
                listener.onEvent(instance.getServiceName(), this.buildUpstreamJsonFromInstance(instance), ChangedEventListener.Event.DELETED);
            }
        }
        if (!(updatedInstances = currentInstances.stream().filter(currentInstance -> previousInstances.stream().anyMatch(previousInstance -> currentInstance.getInstanceId().equals(previousInstance.getInstanceId()) && !currentInstance.equals(previousInstance))).collect(Collectors.toSet())).isEmpty()) {
            for (Instance instance : updatedInstances) {
                listener.onEvent(instance.getServiceName(), this.buildUpstreamJsonFromInstance(instance), ChangedEventListener.Event.UPDATED);
            }
        }
    }

    private String buildUpstreamJsonFromInstance(Instance instance) {
        JsonObject upstreamJson = new JsonObject();
        upstreamJson.addProperty("url", instance.getIp() + ":" + instance.getPort());
        upstreamJson.addProperty("status", (Number)(instance.isHealthy() ? 0 : 1));
        upstreamJson.addProperty("weight", (Number)instance.getWeight());
        Map metadata = instance.getMetadata();
        upstreamJson.addProperty("props", (String)metadata.get("props"));
        boolean secure = false;
        if (metadata.containsKey("secure")) {
            secure = Boolean.parseBoolean((String)metadata.get("secure"));
        }
        String scheme = secure ? "https://" : "http://";
        upstreamJson.addProperty("protocol", Optional.ofNullable((String)metadata.get("protocol")).orElse(scheme));
        return GsonUtils.getInstance().toJson((Object)upstreamJson);
    }

    private String buildInstanceNodeName(InstanceEntity instance) {
        String host = instance.getHost();
        int port = instance.getPort();
        return String.join((CharSequence)":", host, Integer.toString(port));
    }

    private List<InstanceEntity> getInstanceRegisterDTOS(String selectKey) {
        ArrayList<InstanceEntity> result = new ArrayList<InstanceEntity>();
        try {
            List instances = this.namingService.selectInstances(selectKey, this.groupName, true);
            instances.forEach(instance -> result.add(this.convertFromInstance((Instance)instance)));
        }
        catch (Exception e) {
            LOGGER.error("getInstanceRegisterDTOS error", (Throwable)e);
        }
        return result;
    }

    private InstanceEntity convertFromInstance(Instance instance) {
        InstanceEntity instanceEntity = new InstanceEntity();
        instanceEntity.setPort(Integer.valueOf(instance.getPort()));
        instanceEntity.setHost(instance.getIp());
        instanceEntity.setAppName(instance.getServiceName());
        instanceEntity.setUri(this.getURI(instance.getMetadata(), instance));
        return instanceEntity;
    }

    private URI getURI(Map<String, String> metadata, Instance instance) {
        boolean secure = false;
        if (metadata.containsKey("secure")) {
            secure = Boolean.parseBoolean(metadata.get("secure"));
        }
        String scheme = secure ? "https" : "http";
        int port = instance.getPort();
        if (port <= 0) {
            port = secure ? 443 : 80;
        }
        String uri = String.format("%s://%s:%s", scheme, instance.getIp(), port);
        return URI.create(uri);
    }

    public void close() {
        try {
            if (Objects.nonNull(this.namingService)) {
                for (Map.Entry entry : this.listenerMap.entrySet()) {
                    String key = (String)entry.getKey();
                    EventListener listener = (EventListener)entry.getValue();
                    this.namingService.unsubscribe(key, this.groupName, listener);
                }
                this.listenerMap.clear();
                this.namingService.shutDown();
                this.namingService = null;
                LOGGER.info("nacos registry shutting down...");
            }
        }
        catch (NacosException e) {
            LOGGER.error("nacos registry shutting down error ", (Throwable)e);
            throw new ShenyuException((Throwable)e);
        }
    }
}

