/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.PluginHandleDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.PluginHandleVO;
import org.apache.shenyu.admin.service.PluginHandleService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class PluginHandleDataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final PluginHandleService pluginHandleService;

    public PluginHandleDataConfigsExportImportHandler(PluginHandleService pluginHandleService) {
        this.pluginHandleService = pluginHandleService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.PluginHandle;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<PluginHandleVO> pluginHandleList = this.pluginHandleService.listAllData();
        if (CollectionUtils.isNotEmpty(pluginHandleList)) {
            return Optional.of(JsonUtils.toJson(pluginHandleList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List pluginHandleList = GsonUtils.getInstance().fromList(data, PluginHandleDTO.class);
        ConfigImportResult configImportResult = this.pluginHandleService.importData(pluginHandleList, context);
        context.getResult().put("pluginHandleImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("pluginHandleImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

