/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.client.flow;

import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.pojo.DefaultServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceResourceProvider;
import com.tencent.polaris.api.pojo.ServiceRule;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;

public class DefaultServiceResourceProvider
implements ServiceResourceProvider {
    private final Extensions extensions;

    public DefaultServiceResourceProvider(Extensions extensions) {
        this.extensions = extensions;
    }

    @Override
    public ServiceRule getServiceRule(ServiceEventKey serviceEventKey) {
        DefaultServiceEventKeysProvider getResourcesRequest = new DefaultServiceEventKeysProvider();
        getResourcesRequest.setSvcEventKey(serviceEventKey);
        getResourcesRequest.setUseCache(true);
        DefaultFlowControlParam flowControlParam = new DefaultFlowControlParam(this.extensions.getConfiguration().getGlobal().getAPI());
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources(this.extensions, true, getResourcesRequest, flowControlParam);
        return resourcesResponse.getServiceRule(serviceEventKey);
    }

    @Override
    public ServiceInstances getServiceInstances(ServiceKey serviceKey) {
        ServiceEventKey serviceEventKey = new ServiceEventKey(serviceKey, ServiceEventKey.EventType.INSTANCE);
        DefaultServiceEventKeysProvider getResourcesRequest = new DefaultServiceEventKeysProvider();
        getResourcesRequest.setSvcEventKey(serviceEventKey);
        getResourcesRequest.setUseCache(true);
        DefaultFlowControlParam flowControlParam = new DefaultFlowControlParam(this.extensions.getConfiguration().getGlobal().getAPI());
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources(this.extensions, true, getResourcesRequest, flowControlParam);
        return resourcesResponse.getServiceInstances(serviceEventKey);
    }
}

