/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.connector.grpc.codec;

import com.tencent.polaris.api.plugin.registry.AbstractCacheHandler;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.client.pojo.ServiceRuleByProto;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.service.manage.ResponseProto;

public class CircuitBreakCacheHandler
extends AbstractCacheHandler {
    @Override
    public ServiceEventKey.EventType getTargetEventType() {
        return ServiceEventKey.EventType.CIRCUIT_BREAKING;
    }

    @Override
    protected String getRevision(ResponseProto.DiscoverResponse discoverResponse) {
        CircuitBreakerProto.CircuitBreaker circuitBreaker = discoverResponse.getCircuitBreaker();
        if (null == circuitBreaker) {
            return "";
        }
        return circuitBreaker.getRevision().getValue();
    }

    @Override
    public RegistryCacheValue messageToCacheValue(RegistryCacheValue oldValue, Object newValue, boolean isCacheLoaded) {
        ResponseProto.DiscoverResponse discoverResponse = (ResponseProto.DiscoverResponse)newValue;
        CircuitBreakerProto.CircuitBreaker circuitBreaker = discoverResponse.getCircuitBreaker();
        String revision = "";
        if (null != circuitBreaker) {
            revision = circuitBreaker.getRevision().getValue();
        }
        return new ServiceRuleByProto(circuitBreaker, revision, isCacheLoaded, this.getTargetEventType());
    }
}

