/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.moderation;

import java.util.Objects;
import org.springframework.ai.model.ModelRequest;
import org.springframework.ai.moderation.ModerationMessage;
import org.springframework.ai.moderation.ModerationOptions;
import org.springframework.ai.moderation.ModerationOptionsBuilder;

public class ModerationPrompt
implements ModelRequest<ModerationMessage> {
    private final ModerationMessage message;
    private ModerationOptions moderationModelOptions;

    public ModerationPrompt(ModerationMessage message, ModerationOptions moderationModelOptions) {
        this.message = message;
        this.moderationModelOptions = moderationModelOptions;
    }

    public ModerationPrompt(String instructions, ModerationOptions moderationOptions) {
        this(new ModerationMessage(instructions), moderationOptions);
    }

    public ModerationPrompt(String instructions) {
        this(new ModerationMessage(instructions), ModerationOptionsBuilder.builder().build());
    }

    @Override
    public ModerationMessage getInstructions() {
        return this.message;
    }

    @Override
    public ModerationOptions getOptions() {
        return this.moderationModelOptions;
    }

    public void setOptions(ModerationOptions moderationModelOptions) {
        this.moderationModelOptions = moderationModelOptions;
    }

    public String toString() {
        return "ModerationPrompt{message=" + String.valueOf(this.message) + ", moderationModelOptions=" + String.valueOf(this.moderationModelOptions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModerationPrompt)) {
            return false;
        }
        ModerationPrompt that = (ModerationPrompt)o;
        return Objects.equals(this.message, that.message) && Objects.equals(this.moderationModelOptions, that.moderationModelOptions);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.moderationModelOptions);
    }
}

