/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch.ilm.ForceMergeConfiguration;
import co.elastic.clients.elasticsearch.ilm.ShrinkConfiguration;
import co.elastic.clients.elasticsearch.indices.rollover.RolloverConditions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Configurations
implements JsonpSerializable {
    @Nullable
    private final RolloverConditions rollover;
    @Nullable
    private final ForceMergeConfiguration forcemerge;
    @Nullable
    private final ShrinkConfiguration shrink;
    public static final JsonpDeserializer<Configurations> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Configurations::setupConfigurationsDeserializer);

    private Configurations(Builder builder) {
        this.rollover = builder.rollover;
        this.forcemerge = builder.forcemerge;
        this.shrink = builder.shrink;
    }

    public static Configurations of(Function<Builder, ObjectBuilder<Configurations>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final RolloverConditions rollover() {
        return this.rollover;
    }

    @Nullable
    public final ForceMergeConfiguration forcemerge() {
        return this.forcemerge;
    }

    @Nullable
    public final ShrinkConfiguration shrink() {
        return this.shrink;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.rollover != null) {
            generator.writeKey("rollover");
            this.rollover.serialize(generator, mapper);
        }
        if (this.forcemerge != null) {
            generator.writeKey("forcemerge");
            this.forcemerge.serialize(generator, mapper);
        }
        if (this.shrink != null) {
            generator.writeKey("shrink");
            this.shrink.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupConfigurationsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::rollover, RolloverConditions._DESERIALIZER, "rollover");
        op.add(Builder::forcemerge, ForceMergeConfiguration._DESERIALIZER, "forcemerge");
        op.add(Builder::shrink, ShrinkConfiguration._DESERIALIZER, "shrink");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Configurations> {
        @Nullable
        private RolloverConditions rollover;
        @Nullable
        private ForceMergeConfiguration forcemerge;
        @Nullable
        private ShrinkConfiguration shrink;

        public final Builder rollover(@Nullable RolloverConditions value) {
            this.rollover = value;
            return this;
        }

        public final Builder rollover(Function<RolloverConditions.Builder, ObjectBuilder<RolloverConditions>> fn) {
            return this.rollover(fn.apply(new RolloverConditions.Builder()).build());
        }

        public final Builder forcemerge(@Nullable ForceMergeConfiguration value) {
            this.forcemerge = value;
            return this;
        }

        public final Builder forcemerge(Function<ForceMergeConfiguration.Builder, ObjectBuilder<ForceMergeConfiguration>> fn) {
            return this.forcemerge(fn.apply(new ForceMergeConfiguration.Builder()).build());
        }

        public final Builder shrink(@Nullable ShrinkConfiguration value) {
            this.shrink = value;
            return this;
        }

        public final Builder shrink(Function<ShrinkConfiguration.Builder, ObjectBuilder<ShrinkConfiguration>> fn) {
            return this.shrink(fn.apply(new ShrinkConfiguration.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Configurations build() {
            this._checkSingleUse();
            return new Configurations(this);
        }
    }
}

