/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ai.proxy;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.AiProxyHandle;
import org.apache.shenyu.common.enums.AiModelProviderEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.ai.common.config.AiCommonConfig;
import org.apache.shenyu.plugin.ai.common.strategy.AiModel;
import org.apache.shenyu.plugin.ai.common.strategy.AiModelFactory;
import org.apache.shenyu.plugin.ai.proxy.handler.AiProxyPluginHandler;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.context.ShenyuContext;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class AiProxyPlugin
extends AbstractShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AiProxyPlugin.class);
    private final List<HttpMessageReader<?>> messageReaders;

    public AiProxyPlugin(List<HttpMessageReader<?>> messageReaders) {
        this.messageReaders = messageReaders;
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        AiCommonConfig aiCommonConfig = (AiCommonConfig)Singleton.INST.get(AiCommonConfig.class);
        if (Objects.isNull(aiCommonConfig)) {
            aiCommonConfig = new AiCommonConfig();
        }
        ShenyuContext shenyuContext = (ShenyuContext)exchange.getAttribute("context");
        Objects.requireNonNull(shenyuContext);
        AiProxyHandle selectorHandle = (AiProxyHandle)AiProxyPluginHandler.SELECTOR_CACHED_HANDLE.get().obtainHandle((Object)CacheKeyUtils.INST.getKey(selector.getId(), "default_rule"));
        if (Objects.nonNull(selectorHandle)) {
            AiCommonConfig tmp = new AiCommonConfig();
            tmp.setProvider(Optional.ofNullable(selectorHandle.getProvider()).orElse(aiCommonConfig.getProvider()));
            tmp.setBaseUrl(Optional.ofNullable(selectorHandle.getBaseUrl()).orElse(aiCommonConfig.getBaseUrl()));
            tmp.setApiKey(Optional.ofNullable(selectorHandle.getApiKey()).orElse(aiCommonConfig.getApiKey()));
            tmp.setModel(Optional.ofNullable(selectorHandle.getModel()).orElse(aiCommonConfig.getModel()));
            tmp.setTemperature(Optional.ofNullable(selectorHandle.getTemperature()).orElse(aiCommonConfig.getTemperature()));
            tmp.setMaxTokens(Optional.ofNullable(selectorHandle.getMaxTokens()).orElse(aiCommonConfig.getMaxTokens()));
            tmp.setStream(Optional.ofNullable(selectorHandle.getStream()).orElse(aiCommonConfig.getStream()));
            aiCommonConfig = tmp;
        }
        if (Objects.isNull(aiCommonConfig.getBaseUrl())) {
            LOG.error("AI proxy plugin: baseUrl is null");
            return chain.execute(exchange);
        }
        shenyuContext.setRpcType(RpcTypeEnum.AI.getName());
        exchange.getAttributes().put("context", shenyuContext);
        exchange.getAttributes().put("httpDomain", aiCommonConfig.getBaseUrl());
        exchange.getAttributes().put("httpTimeOut", 180000L);
        exchange.getAttributes().put("httpRetry", 0);
        String provider = aiCommonConfig.getProvider();
        AiModelProviderEnum providerEnum = AiModelProviderEnum.getByName((String)provider);
        if (Objects.isNull(providerEnum)) {
            return Mono.error((Throwable)new IllegalArgumentException("Invalid AI model provider"));
        }
        AiModel aiModel = AiModelFactory.createAiModel((AiModelProviderEnum)providerEnum);
        if (Objects.isNull(aiModel)) {
            return Mono.error((Throwable)new IllegalStateException("Failed to create AI model"));
        }
        exchange.getAttributes().put("ai_model", aiModel);
        return aiModel.invoke(aiCommonConfig, exchange, chain, this.messageReaders);
    }

    public int getOrder() {
        return PluginEnum.AI_PROXY.getCode();
    }

    public String named() {
        return PluginEnum.AI_PROXY.getName();
    }
}

