/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.util;

import com.codahale.metrics.MetricRegistry;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class InternalMetricsFactory {
    private static final ConcurrentMap<String, MetricRegistry> getRegistryCache = new ConcurrentHashMap<String, MetricRegistry>();
    private static final MetricRegistry defaultMetricsRegistry = new MetricRegistry();

    public static MetricRegistry getRegistryInstance(String name) {
        MetricRegistry instance = (MetricRegistry)getRegistryCache.get(name);
        if (instance == null) {
            getRegistryCache.putIfAbsent(name, new MetricRegistry());
            instance = (MetricRegistry)getRegistryCache.get(name);
        }
        return instance;
    }

    public static MetricRegistry getRegistryInstance(String name, String ... names) {
        String key = MetricRegistry.name((String)name, (String[])names);
        MetricRegistry instance = (MetricRegistry)getRegistryCache.get(key);
        if (instance == null) {
            getRegistryCache.putIfAbsent(key, new MetricRegistry());
            instance = (MetricRegistry)getRegistryCache.get(key);
        }
        return instance;
    }

    public static MetricRegistry getRegistryInstance(Class<?> clazz, String ... names) {
        String key = MetricRegistry.name(clazz, (String[])names);
        MetricRegistry instance = (MetricRegistry)getRegistryCache.get(key);
        if (instance == null) {
            getRegistryCache.putIfAbsent(key, new MetricRegistry());
            instance = (MetricRegistry)getRegistryCache.get(key);
        }
        return instance;
    }

    public static MetricRegistry getDefaultMetricsRegistry() {
        return defaultMetricsRegistry;
    }

    public static Map<String, MetricRegistry> allRegistries() {
        return Collections.unmodifiableMap(getRegistryCache);
    }

    static {
        getRegistryCache.put("default", defaultMetricsRegistry);
    }
}

