/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.common.struct;

import com.alipay.sofa.rpc.common.struct.ValueDifference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MapDifference<K, V> {
    private Map<K, V> onlyOnLeft;
    private Map<K, V> onlyOnRight;
    private Map<K, V> onBoth;
    private Map<K, ValueDifference<V>> differences;

    public MapDifference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        boolean switched = false;
        if (left.size() < right.size()) {
            Map<K, V> tmp = left;
            left = right;
            right = tmp;
            switched = true;
        }
        HashMap<K, V> onlyOnLeft = new HashMap<K, V>();
        HashMap<K, V> onlyOnRight = new HashMap<K, V>(right);
        HashMap<K, V> onBoth = new HashMap<K, V>();
        HashMap differences = new HashMap();
        for (Map.Entry<K, V> entry : left.entrySet()) {
            K leftKey = entry.getKey();
            V leftValue = entry.getValue();
            if (right.containsKey(leftKey)) {
                Object rightValue = onlyOnRight.remove(leftKey);
                if (this.valueEquals(leftValue, rightValue)) {
                    onBoth.put(leftKey, leftValue);
                    continue;
                }
                differences.put(leftKey, switched ? new ValueDifference(rightValue, leftValue) : new ValueDifference<V>(leftValue, rightValue));
                continue;
            }
            onlyOnLeft.put(leftKey, leftValue);
        }
        this.onlyOnLeft = Collections.unmodifiableMap(switched ? onlyOnRight : onlyOnLeft);
        this.onlyOnRight = Collections.unmodifiableMap(switched ? onlyOnLeft : onlyOnRight);
        this.onBoth = Collections.unmodifiableMap(onBoth);
        this.differences = Collections.unmodifiableMap(differences);
    }

    private boolean valueEquals(V leftValue, V rightValue) {
        if (leftValue == rightValue) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        return leftValue.equals(rightValue);
    }

    public boolean areEqual() {
        return this.onlyOnLeft.isEmpty() && this.onlyOnRight.isEmpty() && this.differences.isEmpty();
    }

    public Map<K, V> entriesOnlyOnLeft() {
        return this.onlyOnLeft;
    }

    public Map<K, V> entriesOnlyOnRight() {
        return this.onlyOnRight;
    }

    public Map<K, V> entriesInCommon() {
        return this.onBoth;
    }

    public Map<K, ValueDifference<V>> entriesDiffering() {
        return this.differences;
    }
}

