/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.common.tracer.core.utils;

public class CommonUtils {
    private static int LONG_BYTES = 8;
    private static int LONG_HEX_STRING_BYTES = LONG_BYTES * 2;

    public static <T extends Number> T parseNum(T num, T defaultInt) {
        return num == null ? defaultInt : num;
    }

    public static long[] hexToDualLong(String hexString) {
        int i;
        int length = hexString.length();
        if (length < 1) {
            throw new IllegalArgumentException("Malformed id(length must be more than zero): " + hexString);
        }
        if (length > LONG_HEX_STRING_BYTES * 2) {
            throw new IllegalArgumentException("Malformed id(length must be less than 2 times lengh of type long): " + hexString);
        }
        int charLast = length - 1;
        long[] result = new long[2];
        result[1] = 0L;
        result[0] = 0L;
        for (i = 0; charLast >= 0 && i < LONG_BYTES * 2; --charLast, ++i) {
            result[1] = result[1] + (((long)Character.digit(hexString.charAt(charLast), 16) & 0xFFL) << 4 * i);
        }
        for (i = 0; charLast >= 0 && i < LONG_BYTES * 2; --charLast, ++i) {
            result[0] = result[0] + (((long)Character.digit(hexString.charAt(charLast), 16) & 0xFFL) << 4 * i);
        }
        return result;
    }

    public static long hexToLong(String hexString) {
        int length = hexString.length();
        if (length < 1) {
            throw new IllegalArgumentException("Malformed id(length must be more than zero): " + hexString);
        }
        if (length > LONG_HEX_STRING_BYTES) {
            throw new IllegalArgumentException("Malformed id(length must be less than 2 times lengh of type long): " + hexString);
        }
        int charLast = length - 1;
        long result = 0L;
        for (int i = 0; charLast >= 0 && i < LONG_BYTES * 2; --charLast, ++i) {
            result += ((long)Character.digit(hexString.charAt(charLast), 16) & 0xFFL) << 4 * i;
        }
        return result;
    }

    public static boolean isHexString(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            return false;
        }
        return true;
    }
}

