/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.view.freemarker;

import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.FastByteArrayOutputStream;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.result.view.AbstractUrlBasedView;
import org.springframework.web.reactive.result.view.RequestContext;
import org.springframework.web.reactive.result.view.freemarker.FreeMarkerConfig;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class FreeMarkerView
extends AbstractUrlBasedView {
    public static final String SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE = "springMacroRequestContext";
    @Nullable
    private Configuration configuration;
    @Nullable
    private String encoding;
    private boolean exposeSpringMacroHelpers = true;

    public void setConfiguration(@Nullable Configuration configuration) {
        this.configuration = configuration;
    }

    @Nullable
    protected Configuration getConfiguration() {
        return this.configuration;
    }

    protected Configuration obtainConfiguration() {
        Configuration configuration = this.getConfiguration();
        Assert.state((configuration != null ? 1 : 0) != 0, (String)"No Configuration set");
        return configuration;
    }

    public void setEncoding(@Nullable String encoding) {
        this.encoding = encoding;
    }

    @Nullable
    protected String getEncoding() {
        return this.encoding;
    }

    public void setExposeSpringMacroHelpers(boolean exposeSpringMacroHelpers) {
        this.exposeSpringMacroHelpers = exposeSpringMacroHelpers;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.getConfiguration() == null) {
            FreeMarkerConfig config = this.autodetectConfiguration();
            this.setConfiguration(config.getConfiguration());
        }
    }

    protected FreeMarkerConfig autodetectConfiguration() throws BeansException {
        try {
            return (FreeMarkerConfig)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.obtainApplicationContext(), FreeMarkerConfig.class, (boolean)true, (boolean)false);
        }
        catch (NoSuchBeanDefinitionException ex) {
            throw new ApplicationContextException("Must define a single FreeMarkerConfig bean in this application context (may be inherited): FreeMarkerConfigurer is the usual implementation. This bean may be given any name.", (Throwable)ex);
        }
    }

    @Override
    public boolean checkResourceExists(Locale locale) throws Exception {
        try {
            this.getTemplate(locale);
            return true;
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (ParseException ex) {
            throw new ApplicationContextException("Failed to parse FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new ApplicationContextException("Could not load FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex);
        }
    }

    @Override
    public Mono<Boolean> resourceExists(Locale locale) {
        return this.lookupTemplate(locale).map(template -> Boolean.TRUE).switchIfEmpty(Mono.just((Object)Boolean.FALSE)).onErrorReturn(FileNotFoundException.class, (Object)Boolean.FALSE).onErrorMap(ParseException.class, ex -> new ApplicationContextException("Failed to parse FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex)).onErrorMap(IOException.class, ex -> new ApplicationContextException("Could not load FreeMarker template for URL [" + this.getUrl() + "]", (Throwable)ex));
    }

    @Override
    protected Mono<Map<String, Object>> getModelAttributes(@Nullable Map<String, ?> model, ServerWebExchange exchange2) {
        if (this.exposeSpringMacroHelpers) {
            if (model != null && model.containsKey(SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE)) {
                throw new IllegalStateException("Cannot expose bind macro helper 'springMacroRequestContext' because of an existing model object of the same name");
            }
            HashMap<String, Object> attributes = model != null ? new HashMap<String, Object>(model) : new HashMap();
            attributes.put(SPRING_MACRO_REQUEST_CONTEXT_ATTRIBUTE, new RequestContext(exchange2, attributes, (MessageSource)this.obtainApplicationContext(), this.getRequestDataValueProcessor()));
            return super.getModelAttributes(attributes, exchange2);
        }
        return super.getModelAttributes(model, exchange2);
    }

    @Override
    protected Mono<Void> renderInternal(Map<String, Object> renderAttributes, @Nullable MediaType contentType, ServerWebExchange exchange2) {
        return exchange2.getResponse().writeWith((Publisher)Mono.defer(() -> {
            SimpleHash freeMarkerModel = this.getTemplateModel(renderAttributes, exchange2);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(exchange2.getLogPrefix() + "Rendering [" + this.getUrl() + "]"));
            }
            Locale locale = LocaleContextHolder.getLocale((LocaleContext)exchange2.getLocaleContext());
            return this.lookupTemplate(locale).flatMap(template -> {
                try {
                    FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
                    Charset charset = this.getCharset(contentType);
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, charset);
                    template.process((Object)freeMarkerModel, (Writer)writer);
                    byte[] bytes = bos.toByteArrayUnsafe();
                    DataBuffer buffer = exchange2.getResponse().bufferFactory().wrap(bytes);
                    return Mono.just((Object)buffer);
                }
                catch (TemplateException | IOException ex) {
                    String message = "Could not load FreeMarker template for URL [" + this.getUrl() + "]";
                    return Mono.error((Throwable)new IllegalStateException(message, ex));
                }
            });
        }).doOnDiscard(DataBuffer.class, DataBufferUtils::release));
    }

    private Charset getCharset(@Nullable MediaType mediaType) {
        return Optional.ofNullable(mediaType).map(MimeType::getCharset).orElse(this.getDefaultCharset());
    }

    protected SimpleHash getTemplateModel(Map<String, Object> model, ServerWebExchange exchange2) {
        SimpleHash fmModel = new SimpleHash(this.getObjectWrapper());
        fmModel.putAll(model);
        return fmModel;
    }

    protected ObjectWrapper getObjectWrapper() {
        ObjectWrapper ow = this.obtainConfiguration().getObjectWrapper();
        Version version = Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS;
        return ow != null ? ow : new DefaultObjectWrapperBuilder(version).build();
    }

    @Deprecated(since="6.1", forRemoval=true)
    protected Template getTemplate(Locale locale) throws IOException {
        return this.getEncoding() != null ? this.obtainConfiguration().getTemplate(this.getUrl(), locale, this.getEncoding()) : this.obtainConfiguration().getTemplate(this.getUrl(), locale);
    }

    protected Mono<Template> lookupTemplate(Locale locale) {
        return Mono.fromCallable(() -> this.getEncoding() != null ? this.obtainConfiguration().getTemplate(this.getUrl(), locale, this.getEncoding()) : this.obtainConfiguration().getTemplate(this.getUrl(), locale)).subscribeOn(Schedulers.boundedElastic());
    }
}

